/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.search.query;

import io.camunda.service.search.page.SearchQueryPage;
import io.camunda.service.search.page.SearchQueryPageBuilders;
import io.camunda.util.ObjectBuilder;
import java.util.Objects;
import java.util.function.Function;

public interface SearchQueryBase {
    public SearchQueryPage page();

    public static abstract class AbstractQueryBuilder<T extends AbstractQueryBuilder<T>> {
        private static final SearchQueryPage DEFAULT_PAGE = SearchQueryPage.of(b -> b);
        private SearchQueryPage page;

        protected abstract T self();

        protected SearchQueryPage page() {
            return Objects.requireNonNullElse(this.page, DEFAULT_PAGE);
        }

        public T page(SearchQueryPage value) {
            this.page = value;
            return this.self();
        }

        public T page(Function<SearchQueryPage.Builder, ObjectBuilder<SearchQueryPage>> fn) {
            return this.page(SearchQueryPageBuilders.page(fn));
        }
    }
}

