/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.search.query;

import io.camunda.service.search.filter.FilterBuilders;
import io.camunda.service.search.filter.IncidentFilter;
import io.camunda.service.search.page.SearchQueryPage;
import io.camunda.service.search.query.SearchQueryBase;
import io.camunda.service.search.query.TypedSearchQuery;
import io.camunda.service.search.query.TypedSearchQueryBuilder;
import io.camunda.service.search.sort.IncidentSort;
import io.camunda.service.search.sort.SortOptionBuilders;
import io.camunda.util.ObjectBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.function.Function;

public final class IncidentQuery
extends Record
implements TypedSearchQuery<IncidentFilter, IncidentSort> {
    private final IncidentFilter filter;
    private final IncidentSort sort;
    private final SearchQueryPage page;

    public IncidentQuery(IncidentFilter filter, IncidentSort sort, SearchQueryPage page) {
        this.filter = filter;
        this.sort = sort;
        this.page = page;
    }

    public static IncidentQuery of(Function<Builder, ObjectBuilder<IncidentQuery>> fn) {
        return (IncidentQuery)fn.apply(new Builder()).build();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IncidentQuery.class, "filter;sort;page", "filter", "sort", "page"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IncidentQuery.class, "filter;sort;page", "filter", "sort", "page"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IncidentQuery.class, "filter;sort;page", "filter", "sort", "page"}, this, o);
    }

    @Override
    public IncidentFilter filter() {
        return this.filter;
    }

    @Override
    public IncidentSort sort() {
        return this.sort;
    }

    @Override
    public SearchQueryPage page() {
        return this.page;
    }

    public static final class Builder
    extends SearchQueryBase.AbstractQueryBuilder<Builder>
    implements TypedSearchQueryBuilder<IncidentQuery, Builder, IncidentFilter, IncidentSort> {
        private static final IncidentFilter EMPTY_FILTER = FilterBuilders.incident().build();
        private static final IncidentSort EMPTY_SORT = SortOptionBuilders.incident().build();
        private IncidentFilter filter;
        private IncidentSort sort;

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Builder filter(IncidentFilter value) {
            this.filter = value;
            return this;
        }

        @Override
        public Builder sort(IncidentSort value) {
            this.sort = value;
            return this;
        }

        @Override
        public Builder filter(Function<IncidentFilter.Builder, ObjectBuilder<IncidentFilter>> fn) {
            return this.filter(FilterBuilders.incident(fn));
        }

        @Override
        public Builder sort(Function<IncidentSort.Builder, ObjectBuilder<IncidentSort>> fn) {
            return this.sort(SortOptionBuilders.incident(fn));
        }

        public IncidentQuery build() {
            this.filter = Objects.requireNonNullElse(this.filter, EMPTY_FILTER);
            this.sort = Objects.requireNonNullElse(this.sort, EMPTY_SORT);
            return new IncidentQuery(this.filter, this.sort, this.page());
        }
    }
}

