/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.search.core;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.search.clients.core.SearchQueryRequest;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.service.search.core.SearchQueryExecutionException;
import io.camunda.service.search.filter.FilterBase;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.service.search.query.TypedSearchQuery;
import io.camunda.service.search.sort.SortOption;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.service.transformers.filter.AuthenticationTransformer;
import io.camunda.service.transformers.filter.FilterTransformer;
import io.camunda.service.transformers.query.SearchQueryResultTransformer;
import io.camunda.service.transformers.query.TypedSearchQueryTransformer;

public final class SearchClientBasedQueryExecutor {
    private final CamundaSearchClient searchClient;
    private final ServiceTransformers transformers;
    private final Authentication authentication;

    public SearchClientBasedQueryExecutor(CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        this.searchClient = searchClient;
        this.transformers = transformers;
        this.authentication = authentication;
    }

    public <T extends FilterBase, S extends SortOption, R> SearchQueryResult<R> search(TypedSearchQuery<T, S> query, Class<R> documentClass) {
        SearchQuery authCheck = this.getAuthenticationCheckIfPresent();
        TypedSearchQueryTransformer<T, S> transformer = this.getSearchQueryRequestTransformer(query);
        SearchQueryRequest searchRequest = transformer.applyWithAuthentication(query, authCheck);
        SearchQueryResultTransformer<R> responseTransformer = this.getSearchResultTransformer();
        return (SearchQueryResult)this.searchClient.search(searchRequest, documentClass).fold(e -> {
            throw this.rethrowRuntimeException((Exception)e);
        }, responseTransformer::apply);
    }

    private SearchQuery getAuthenticationCheckIfPresent() {
        if (this.authentication != null) {
            AuthenticationTransformer transformer = this.getAuthenticationTransformer();
            return transformer.apply(this.authentication);
        }
        return null;
    }

    private <T extends FilterBase, S extends SortOption> TypedSearchQueryTransformer<T, S> getSearchQueryRequestTransformer(TypedSearchQuery<T, S> query) {
        return this.transformers.getTypedSearchQueryTransformer(query.getClass());
    }

    private AuthenticationTransformer getAuthenticationTransformer() {
        FilterTransformer transformer = this.transformers.getFilterTransformer(Authentication.class);
        return (AuthenticationTransformer)transformer;
    }

    private <R> SearchQueryResultTransformer<R> getSearchResultTransformer() {
        return new SearchQueryResultTransformer();
    }

    private SearchQueryExecutionException rethrowRuntimeException(Exception e) {
        return new SearchQueryExecutionException("Failed to execute search query", e);
    }
}

