/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.entities.UserTaskEntity;
import io.camunda.service.search.core.SearchQueryService;
import io.camunda.service.search.query.SearchQueryBuilders;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.service.search.query.UserTaskQuery;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.util.ObjectBuilder;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerUserTaskAssignmentRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerUserTaskCompletionRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerUserTaskUpdateRequest;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class UserTaskServices
extends SearchQueryService<UserTaskServices, UserTaskQuery, UserTaskEntity> {
    public UserTaskServices(BrokerClient brokerClient, CamundaSearchClient dataStoreClient) {
        this(brokerClient, dataStoreClient, null, null);
    }

    public UserTaskServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
    }

    @Override
    public UserTaskServices withAuthentication(Authentication authentication) {
        return new UserTaskServices(this.brokerClient, this.searchClient, this.transformers, authentication);
    }

    @Override
    public SearchQueryResult<UserTaskEntity> search(UserTaskQuery query) {
        return this.executor.search(query, UserTaskEntity.class);
    }

    @Override
    public SearchQueryResult<UserTaskEntity> search(Function<UserTaskQuery.Builder, ObjectBuilder<UserTaskQuery>> fn) {
        return this.search(SearchQueryBuilders.userTaskSearchQuery(fn));
    }

    public CompletableFuture<UserTaskRecord> assignUserTask(long userTaskKey, String assignee, String action, boolean allowOverride) {
        return this.sendBrokerRequest(new BrokerUserTaskAssignmentRequest(userTaskKey, assignee, action, allowOverride ? UserTaskIntent.ASSIGN : UserTaskIntent.CLAIM));
    }

    public CompletableFuture<UserTaskRecord> completeUserTask(long userTaskKey, Map<String, Object> variables, String action) {
        return this.sendBrokerRequest(new BrokerUserTaskCompletionRequest(userTaskKey, this.getDocumentOrEmpty(variables), action));
    }

    public CompletableFuture<UserTaskRecord> unassignUserTask(long userTaskKey, String action) {
        return this.sendBrokerRequest(new BrokerUserTaskAssignmentRequest(userTaskKey, "", action, UserTaskIntent.ASSIGN));
    }

    public CompletableFuture<UserTaskRecord> updateUserTask(long userTaskKey, UserTaskRecord changeset, String action) {
        return this.sendBrokerRequest(new BrokerUserTaskUpdateRequest(userTaskKey, changeset, action));
    }
}

