/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.ApiServices;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerDeleteResourceRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerDeployResourceRequest;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.resource.ResourceDeletionRecord;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class ResourceServices
extends ApiServices<ResourceServices> {
    public ResourceServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
    }

    @Override
    public ResourceServices withAuthentication(Authentication authentication) {
        return new ResourceServices(this.brokerClient, this.searchClient, this.transformers, authentication);
    }

    public CompletableFuture<DeploymentRecord> deployResources(DeployResourcesRequest deployResourcesRequest) {
        BrokerDeployResourceRequest brokerRequest = new BrokerDeployResourceRequest();
        deployResourcesRequest.resources().forEach((arg_0, arg_1) -> ((BrokerDeployResourceRequest)brokerRequest).addResource(arg_0, arg_1));
        brokerRequest.setTenantId(deployResourcesRequest.tenantId());
        return this.sendBrokerRequest(brokerRequest);
    }

    public CompletableFuture<ResourceDeletionRecord> deleteResource(ResourceDeletionRequest request) {
        BrokerDeleteResourceRequest brokerRequest = new BrokerDeleteResourceRequest().setResourceKey(request.resourceKey());
        if (request.operationReference() != null) {
            brokerRequest.setOperationReference(request.operationReference().longValue());
        }
        return this.sendBrokerRequest(brokerRequest);
    }

    public record DeployResourcesRequest(Map<String, byte[]> resources, String tenantId) {
    }

    public record ResourceDeletionRequest(long resourceKey, Long operationReference) {
    }
}

