/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryOperation<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryOperation.class);
    private final RetryConsumer<T> retryConsumer;
    private final int noOfRetry;
    private final int delayInterval;
    private final TimeUnit timeUnit;
    private final RetryPredicate<T> retryPredicate;
    private final List<Class<? extends Throwable>> exceptionList;
    private final String message;

    private RetryOperation(RetryConsumer<T> retryConsumer, int noOfRetry, int delayInterval, TimeUnit timeUnit, RetryPredicate<T> retryPredicate, List<Class<? extends Throwable>> exceptionList, String message) {
        this.retryConsumer = retryConsumer;
        this.noOfRetry = noOfRetry;
        this.delayInterval = delayInterval;
        this.timeUnit = timeUnit;
        this.retryPredicate = retryPredicate;
        this.exceptionList = exceptionList;
        this.message = message;
    }

    public static <T> OperationBuilder<T> newBuilder() {
        return new OperationBuilder();
    }

    public T retry() throws Exception {
        T result = null;
        int retries = 0;
        while (retries < this.noOfRetry) {
            try {
                result = this.retryConsumer.evaluate();
                if (Objects.nonNull(this.retryPredicate)) {
                    boolean shouldItRetry = this.retryPredicate.shouldRetry(result);
                    if (shouldItRetry) {
                        retries = this.increaseRetryCountAndSleep(retries);
                        continue;
                    }
                    return result;
                }
                return result;
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Retry Operation %s failed: %s", this.message, e.getMessage()), (Throwable)e);
                retries = this.handleException(retries, e);
            }
        }
        return result;
    }

    private int handleException(int retries, Exception e) throws Exception {
        if (this.exceptionList.isEmpty() || this.exceptionList.stream().anyMatch(ex -> ex.isAssignableFrom(e.getClass()))) {
            if ((retries = this.increaseRetryCountAndSleep(retries)) == this.noOfRetry) {
                throw e;
            }
        } else {
            throw e;
        }
        return retries;
    }

    private int increaseRetryCountAndSleep(int retries) {
        if (++retries < this.noOfRetry && this.delayInterval > 0) {
            try {
                if (retries % 20 == 0) {
                    LOGGER.info("{} - Waiting {} {}. {}/{}", new Object[]{this.message, this.delayInterval, this.timeUnit, retries, this.noOfRetry});
                } else {
                    LOGGER.debug("{} - Waiting {} {}. {}/{}", new Object[]{this.message, this.delayInterval, this.timeUnit, retries, this.noOfRetry});
                }
                this.timeUnit.sleep(this.delayInterval);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
        return retries;
    }

    public static interface RetryConsumer<T> {
        public T evaluate() throws Exception;
    }

    public static interface RetryPredicate<T> {
        public boolean shouldRetry(T var1);
    }

    public static final class OperationBuilder<T> {
        private RetryConsumer<T> iRetryConsumer;
        private int iNoOfRetry;
        private int iDelayInterval;
        private TimeUnit iTimeUnit;
        private RetryPredicate<T> iRetryPredicate;
        private Class<? extends Throwable>[] exceptionClasses;
        private String message = "";

        private OperationBuilder() {
        }

        public OperationBuilder<T> retryConsumer(RetryConsumer<T> retryConsumer) {
            this.iRetryConsumer = retryConsumer;
            return this;
        }

        public OperationBuilder<T> noOfRetry(int noOfRetry) {
            this.iNoOfRetry = noOfRetry;
            return this;
        }

        public OperationBuilder<T> delayInterval(int delayInterval, TimeUnit timeUnit) {
            this.iDelayInterval = delayInterval;
            this.iTimeUnit = timeUnit;
            return this;
        }

        public OperationBuilder<T> retryPredicate(RetryPredicate<T> retryPredicate) {
            this.iRetryPredicate = retryPredicate;
            return this;
        }

        @SafeVarargs
        public final OperationBuilder<T> retryOn(Class<? extends Throwable> ... exceptionClasses) {
            this.exceptionClasses = exceptionClasses;
            return this;
        }

        public OperationBuilder<T> message(String message) {
            this.message = message;
            return this;
        }

        public RetryOperation<T> build() {
            if (Objects.isNull(this.iRetryConsumer)) {
                throw new RuntimeException("'#retryConsumer:RetryConsumer<T>' not set");
            }
            ArrayList<Class<? extends Throwable>> exceptionList = new ArrayList();
            if (Objects.nonNull(this.exceptionClasses) && this.exceptionClasses.length > 0) {
                exceptionList = Arrays.asList(this.exceptionClasses);
            }
            this.iNoOfRetry = this.iNoOfRetry == 0 ? 1 : this.iNoOfRetry;
            this.iTimeUnit = Objects.isNull((Object)this.iTimeUnit) ? TimeUnit.MILLISECONDS : this.iTimeUnit;
            return new RetryOperation<T>(this.iRetryConsumer, this.iNoOfRetry, this.iDelayInterval, this.iTimeUnit, this.iRetryPredicate, exceptionList, this.message);
        }
    }
}

