/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.store;

import io.camunda.exporter.exceptions.PersistenceException;
import io.camunda.exporter.handlers.ExportHandler;
import io.camunda.exporter.store.BatchRequest;
import io.camunda.webapps.schema.entities.ExporterEntity;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExporterBatchWriter {
    private final Map<ValueType, List<ExportHandler>> handlers = new HashMap<ValueType, List<ExportHandler>>();
    private final Map<EntityIdAndEntityType, EntityAndHandler> cachedEntities = new HashMap<EntityIdAndEntityType, EntityAndHandler>();

    public void addRecord(Record<?> record) {
        ValueType valueType = record.getValueType();
        this.handlers.getOrDefault(valueType, Collections.emptyList()).forEach(handler -> {
            if (handler.handlesRecord(record)) {
                List<String> entityIds = handler.generateIds(record);
                entityIds.forEach(id -> this.updateAndCacheEntity(record, (ExportHandler)handler, (String)id));
            }
        });
    }

    private void updateAndCacheEntity(Record<?> record, ExportHandler handler, String id) {
        EntityIdAndEntityType cacheKey = new EntityIdAndEntityType(id, handler.getEntityType());
        boolean alreadyCached = this.cachedEntities.containsKey(cacheKey);
        Object entity = alreadyCached ? this.cachedEntities.get(cacheKey).entity() : handler.createNewEntity(id);
        handler.updateEntity(record, entity);
        this.cachedEntities.put(cacheKey, new EntityAndHandler((ExporterEntity)entity, handler));
    }

    public void flush(BatchRequest batchRequest) throws PersistenceException {
        if (this.cachedEntities.isEmpty()) {
            return;
        }
        for (EntityAndHandler entityAndHandler : this.cachedEntities.values()) {
            ExporterEntity entity = entityAndHandler.entity();
            ExportHandler handler = entityAndHandler.handler();
            handler.flush(entity, batchRequest);
        }
        batchRequest.execute();
        this.reset();
    }

    public void reset() {
        this.cachedEntities.clear();
    }

    public int getBatchSize() {
        return this.cachedEntities.size();
    }

    private record EntityIdAndEntityType(String entityId, Class<?> entityType) {
    }

    private record EntityAndHandler(ExporterEntity entity, ExportHandler handler) {
    }

    public static class Builder {
        private ExporterBatchWriter writer;

        public static Builder begin() {
            Builder builder = new Builder();
            builder.writer = new ExporterBatchWriter();
            return builder;
        }

        public <T extends ExporterEntity<T>, R extends RecordValue> Builder withHandler(ExportHandler<T, R> handler) {
            this.writer.handlers.computeIfAbsent(handler.getHandledValueType(), k -> new ArrayList()).add(handler);
            return this;
        }

        public ExporterBatchWriter build() {
            return this.writer;
        }
    }
}

