/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.store;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import co.elastic.clients.util.ObjectBuilder;
import io.camunda.exporter.exceptions.PersistenceException;
import io.camunda.exporter.store.BatchRequest;
import io.camunda.exporter.utils.ElasticsearchScriptBuilder;
import io.camunda.webapps.schema.entities.ExporterEntity;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchBatchRequest
implements BatchRequest {
    public static final int UPDATE_RETRY_COUNT = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchBatchRequest.class);
    private final ElasticsearchClient esClient;
    private final BulkRequest.Builder bulkRequestBuilder;
    private final ElasticsearchScriptBuilder scriptBuilder;

    public ElasticsearchBatchRequest(ElasticsearchClient esClient, BulkRequest.Builder bulkRequestBuilder, ElasticsearchScriptBuilder scriptBuilder) {
        this.esClient = esClient;
        this.bulkRequestBuilder = bulkRequestBuilder;
        this.scriptBuilder = scriptBuilder;
    }

    @Override
    public BatchRequest add(String index, ExporterEntity entity) {
        return this.addWithId(index, entity.getId(), entity);
    }

    @Override
    public BatchRequest addWithId(String index, String id, ExporterEntity entity) {
        LOGGER.debug("Add index request for index {} id {} and entity {} ", new Object[]{index, id, entity});
        this.bulkRequestBuilder.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(id)).document((Object)entity)));
        return this;
    }

    @Override
    public BatchRequest addWithRouting(String index, ExporterEntity entity, String routing) {
        LOGGER.debug("Add index request with routing {} for index {} and entity {} ", new Object[]{routing, index, entity});
        this.bulkRequestBuilder.operations(op -> op.index(idx -> (ObjectBuilder)((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(entity.getId())).document((Object)entity).routing(routing)));
        return this;
    }

    @Override
    public BatchRequest upsert(String index, String id, ExporterEntity entity, Map<String, Object> updateFields) {
        return this.upsertWithRouting(index, id, entity, updateFields, null);
    }

    @Override
    public BatchRequest upsertWithRouting(String index, String id, ExporterEntity entity, Map<String, Object> updateFields, String routing) {
        LOGGER.debug("Add upsert request with routing {} for index {} id {} entity {} and update fields {}", new Object[]{routing, index, id, entity, updateFields});
        this.bulkRequestBuilder.operations(op -> op.update(upd -> ((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)upd.index(index)).id(id)).routing(routing)).action(a -> a.doc((Object)updateFields).upsert((Object)entity)).retryOnConflict(Integer.valueOf(3))));
        return this;
    }

    @Override
    public BatchRequest upsertWithScript(String index, String id, ExporterEntity entity, String script, Map<String, Object> parameters) {
        return this.upsertWithScriptAndRouting(index, id, entity, script, parameters, null);
    }

    @Override
    public BatchRequest upsertWithScriptAndRouting(String index, String id, ExporterEntity entity, String script, Map<String, Object> parameters, String routing) {
        LOGGER.debug("Add upsert request with routing {} for index {} id {} entity {} and script {} with parameters {} ", new Object[]{routing, index, id, entity, script, parameters});
        this.bulkRequestBuilder.operations(op -> op.update(upd -> ((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)upd.index(index)).id(id)).routing(routing)).action(a -> a.script(this.scriptBuilder.getScriptWithParameters(script, parameters)).upsert((Object)entity)).retryOnConflict(Integer.valueOf(3))));
        return this;
    }

    @Override
    public BatchRequest update(String index, String id, Map<String, Object> updateFields) {
        LOGGER.debug("Add update request for index {} id {} and update fields {}", new Object[]{index, id, updateFields});
        this.bulkRequestBuilder.operations(op -> op.update(up -> ((UpdateOperation.Builder)((UpdateOperation.Builder)up.index(index)).id(id)).action(a -> a.doc((Object)updateFields)).retryOnConflict(Integer.valueOf(3))));
        return this;
    }

    @Override
    public BatchRequest update(String index, String id, ExporterEntity entity) {
        LOGGER.debug("Add update request for index {} id {} and entity {}", new Object[]{index, id, entity});
        this.bulkRequestBuilder.operations(op -> op.update(up -> ((UpdateOperation.Builder)((UpdateOperation.Builder)up.index(index)).id(id)).action(a -> a.doc((Object)entity)).retryOnConflict(Integer.valueOf(3))));
        return this;
    }

    @Override
    public BatchRequest updateWithScript(String index, String id, String script, Map<String, Object> parameters) {
        LOGGER.debug("Add upsert request with for index {} id {} and script {} with parameters {} ", new Object[]{index, id, script, parameters});
        this.bulkRequestBuilder.operations(op -> op.update(up -> ((UpdateOperation.Builder)((UpdateOperation.Builder)up.index(index)).id(id)).action(a -> a.script(this.scriptBuilder.getScriptWithParameters(script, parameters))).retryOnConflict(Integer.valueOf(3))));
        return this;
    }

    @Override
    public void execute() throws PersistenceException {
        this.execute(false);
    }

    @Override
    public void executeWithRefresh() throws PersistenceException {
        this.execute(true);
    }

    private void execute(boolean shouldRefresh) throws PersistenceException {
        BulkRequest bulkRequest;
        if (shouldRefresh) {
            this.bulkRequestBuilder.refresh(Refresh.True);
        }
        if ((bulkRequest = this.bulkRequestBuilder.build()).operations().isEmpty()) {
            return;
        }
        try {
            BulkResponse bulkResponse = this.esClient.bulk(bulkRequest);
            List items = bulkResponse.items();
            for (BulkResponseItem item : items) {
                if (item.error() == null) continue;
                LOGGER.warn("Bulk request execution failed. {}. Cause: {}.", (Object)item, (Object)item.error().reason());
                throw new PersistenceException("Operation failed: " + item.error().reason());
            }
        }
        catch (ElasticsearchException | IOException ex) {
            throw new PersistenceException("Error when processing bulk request against Elasticsearch: " + ex.getMessage(), ex);
        }
    }
}

