/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.schema;

import io.camunda.exporter.exceptions.IndexSchemaValidationException;
import io.camunda.exporter.schema.IndexMapping;
import io.camunda.exporter.schema.IndexMappingDifference;
import io.camunda.exporter.schema.IndexMappingProperty;
import io.camunda.exporter.schema.SchemaManager;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.webapps.schema.descriptors.IndexTemplateDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexSchemaValidator.class);
    private final SchemaManager schemaManager;

    public IndexSchemaValidator(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public Map<IndexDescriptor, Set<IndexMappingProperty>> validateIndexMappings(Map<String, IndexMapping> mappings, Set<IndexDescriptor> indexDescriptors) throws IndexSchemaValidationException {
        HashMap<IndexDescriptor, Set<IndexMappingProperty>> newFields = new HashMap<IndexDescriptor, Set<IndexMappingProperty>>();
        for (IndexDescriptor indexDescriptor : indexDescriptors) {
            Map<String, IndexMapping> indexMappingsGroup = this.filterIndexMappings(mappings, indexDescriptor);
            if (indexMappingsGroup.isEmpty()) continue;
            IndexMappingDifference difference = this.getIndexMappingDifference(indexDescriptor, indexMappingsGroup);
            this.validateDifferenceAndCollectNewFields(indexDescriptor, difference, newFields);
        }
        return newFields;
    }

    private void validateDifferenceAndCollectNewFields(IndexDescriptor indexDescriptor, IndexMappingDifference difference, Map<IndexDescriptor, Set<IndexMappingProperty>> newFields) {
        if (difference != null && !difference.equal()) {
            LOGGER.debug("Index fields differ from expected. Index name: {}. Difference: {}.", (Object)indexDescriptor.getIndexName(), (Object)difference);
            if (!difference.entriesDiffering().isEmpty()) {
                this.failIfIndexNotDynamic(difference, indexDescriptor);
            }
            if (!difference.entriesOnlyOnRight().isEmpty()) {
                LOGGER.info("Index '{}': Field deletion is requested, will be ignored. Fields: {}", (Object)indexDescriptor.getIndexName(), difference.entriesOnlyOnRight());
            } else if (!difference.entriesOnlyOnLeft().isEmpty()) {
                newFields.put(indexDescriptor, difference.entriesOnlyOnLeft());
            }
        } else {
            LOGGER.debug("Index fields are up to date for Index '{}'.", (Object)indexDescriptor.getIndexName());
        }
    }

    private IndexMappingDifference getIndexMappingDifference(IndexDescriptor indexDescriptor, Map<String, IndexMapping> indexMappingsGroup) {
        IndexMapping indexMappingMustBe = this.schemaManager.readIndex(indexDescriptor);
        List<IndexMappingDifference> differences = indexMappingsGroup.values().stream().map(mapping -> IndexMappingDifference.of(indexMappingMustBe, mapping)).filter(difference -> !difference.equal()).distinct().toList();
        if (differences.isEmpty()) {
            return null;
        }
        if (differences.size() > 1) {
            throw new IndexSchemaValidationException(String.format("Ambiguous schema update. Multiple indices for mapping '%s' has different fields. Differences: '%s'", indexDescriptor.getIndexName(), differences));
        }
        return differences.getFirst();
    }

    private Map<String, IndexMapping> filterIndexMappings(Map<String, IndexMapping> indexMappings, IndexDescriptor indexDescriptor) {
        if (indexDescriptor instanceof IndexTemplateDescriptor) {
            return indexMappings.entrySet().stream().filter(e -> ((String)e.getKey()).equals(((IndexTemplateDescriptor)indexDescriptor).getTemplateName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return indexMappings.entrySet().stream().filter(e -> ((String)e.getKey()).matches(indexDescriptor.getAllVersionsIndexNameRegexPattern())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void failIfIndexNotDynamic(IndexMappingDifference difference, IndexDescriptor indexDescriptor) {
        if (!difference.isLeftDynamic() && !difference.isRightDynamic()) {
            String errorMsg = String.format("Index name: %s. Not supported index changes are introduced. Data migration is required. Changes found: %s", indexDescriptor.getIndexName(), difference.entriesDiffering());
            LOGGER.error(errorMsg);
            throw new IndexSchemaValidationException(errorMsg);
        }
        LOGGER.debug("Index '{}' is dynamic, ignoring changes found: {}", (Object)indexDescriptor.getIndexName(), difference.entriesDiffering());
    }
}

