/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public record IndexMappingProperty(String name, Object typeDefinition) {
    public static InputStream toPropertiesJson(Set<IndexMappingProperty> properties, ObjectMapper mapper) {
        Map<String, Object> propertiesAsMap = properties.stream().collect(Collectors.toMap(IndexMappingProperty::name, IndexMappingProperty::typeDefinition));
        HashMap<String, Map<String, Object>> propertiesBlock = new HashMap<String, Map<String, Object>>();
        propertiesBlock.put("properties", propertiesAsMap);
        try {
            return IOUtils.toInputStream((String)mapper.writeValueAsString(propertiesBlock), (Charset)StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexMappingProperty createIndexMappingProperty(Map.Entry<String, Object> propertiesMapEntry) {
        return new IndexMappingProperty(propertiesMapEntry.getKey(), propertiesMapEntry.getValue());
    }

    public static class Builder {
        private String name;
        private Object typeDefinition;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder typeDefinition(Object typeDefinition) {
            this.typeDefinition = typeDefinition;
            return this;
        }

        public IndexMappingProperty build() {
            return new IndexMappingProperty(this.name, this.typeDefinition);
        }
    }
}

