/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.schema;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import io.camunda.exporter.schema.IndexMapping;
import io.camunda.exporter.schema.IndexMappingProperty;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public record IndexMappingDifference(boolean equal, Set<IndexMappingProperty> entriesOnlyOnLeft, Set<IndexMappingProperty> entriesOnlyOnRight, Set<IndexMappingProperty> entriesInCommon, Set<PropertyDifference> entriesDiffering, boolean isLeftDynamic, boolean isRightDynamic) {
    public static IndexMappingDifference of(IndexMapping left, IndexMapping right) {
        Map<Object, Object> leftMap = left == null ? Map.of() : left.toMap();
        Map<Object, Object> rightMap = right == null ? Map.of() : right.toMap();
        MapDifference difference = Maps.difference(leftMap, rightMap);
        return new IndexMappingDifference(difference.areEqual(), difference.entriesOnlyOnLeft().entrySet().stream().map(IndexMappingProperty::createIndexMappingProperty).collect(Collectors.toSet()), difference.entriesOnlyOnRight().entrySet().stream().map(IndexMappingProperty::createIndexMappingProperty).collect(Collectors.toSet()), difference.entriesInCommon().entrySet().stream().map(IndexMappingProperty::createIndexMappingProperty).collect(Collectors.toSet()), difference.entriesDiffering().entrySet().stream().map(entry -> new PropertyDifference((String)entry.getKey(), new IndexMappingProperty.Builder().name((String)entry.getKey()).typeDefinition(((MapDifference.ValueDifference)entry.getValue()).leftValue()).build(), new IndexMappingProperty.Builder().name((String)entry.getKey()).typeDefinition(((MapDifference.ValueDifference)entry.getValue()).rightValue()).build())).collect(Collectors.toSet()), left == null ? false : left.isDynamic(), right == null ? false : right.isDynamic());
    }

    private record PropertyDifference(String name, IndexMappingProperty leftValue, IndexMappingProperty rightValue) {
    }
}

