/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.schema;

import io.camunda.exporter.schema.IndexMappingProperty;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public record IndexMapping(String indexName, String dynamic, Set<IndexMappingProperty> properties, Map<String, Object> metaProperties) {
    public Map<String, Object> toMap() {
        return this.properties.stream().collect(Collectors.toMap(IndexMappingProperty::name, IndexMappingProperty::typeDefinition));
    }

    public boolean isDynamic() {
        return Boolean.parseBoolean(this.dynamic);
    }

    public static class Builder {
        private Set<IndexMappingProperty> properties;
        private Map<String, Object> metaProperties;
        private String indexName;
        private String dynamic;

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder dynamic(String dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public Builder properties(Set<IndexMappingProperty> properties) {
            this.properties = properties;
            return this;
        }

        public Builder metaProperties(Map<String, Object> metaProperties) {
            this.metaProperties = metaProperties;
            return this;
        }

        public IndexMapping build() {
            return new IndexMapping(this.indexName, this.dynamic, this.properties, this.metaProperties);
        }
    }
}

