/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.schema;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.exporter.config.ElasticsearchProperties;
import io.camunda.exporter.exceptions.ElasticsearchExporterException;
import io.camunda.exporter.schema.IndexMapping;
import io.camunda.exporter.schema.IndexMappingProperty;
import io.camunda.exporter.schema.SchemaManager;
import io.camunda.exporter.schema.SearchEngineClient;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.webapps.schema.descriptors.IndexTemplateDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchSchemaManager
implements SchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchSchemaManager.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final SearchEngineClient elasticsearchClient;
    private final List<IndexDescriptor> indexDescriptors;
    private final List<IndexTemplateDescriptor> indexTemplateDescriptors;
    private final ElasticsearchProperties elasticsearchProperties;

    public ElasticsearchSchemaManager(SearchEngineClient elasticsearchClient, List<IndexDescriptor> indexDescriptors, List<IndexTemplateDescriptor> indexTemplateDescriptors, ElasticsearchProperties elasticsearchProperties) {
        this.elasticsearchClient = elasticsearchClient;
        this.indexDescriptors = indexDescriptors;
        this.indexTemplateDescriptors = indexTemplateDescriptors;
        this.elasticsearchProperties = elasticsearchProperties;
    }

    @Override
    public void initialiseResources() {
        this.indexTemplateDescriptors.forEach(this::createIndexTemplate);
        this.indexDescriptors.forEach(this.elasticsearchClient::createIndex);
    }

    @Override
    public void updateSchema(Map<IndexDescriptor, Set<IndexMappingProperty>> newFields) {
        for (Map.Entry<IndexDescriptor, Set<IndexMappingProperty>> newFieldEntry : newFields.entrySet()) {
            IndexDescriptor descriptor = newFieldEntry.getKey();
            Set<IndexMappingProperty> newProperties = newFieldEntry.getValue();
            if (descriptor instanceof IndexTemplateDescriptor) {
                LOG.info("Updating template: {}", (Object)((IndexTemplateDescriptor)descriptor).getTemplateName());
                this.createIndexTemplate((IndexTemplateDescriptor)descriptor);
                continue;
            }
            LOG.info("Index alias: {}. New fields will be added {}", (Object)descriptor.getAlias(), newProperties);
            this.elasticsearchClient.putMapping(descriptor, newProperties);
        }
    }

    @Override
    public IndexMapping readIndex(IndexDescriptor indexDescriptor) {
        IndexMapping indexMapping;
        block8: {
            InputStream mappingsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(indexDescriptor.getMappingsClasspathFilename());
            try {
                TypeReference<Map<String, Map<String, Object>>> nestedType = new TypeReference<Map<String, Map<String, Object>>>(this){};
                Map mappings = (Map)((Map)MAPPER.readValue(mappingsStream, (TypeReference)nestedType)).get("mappings");
                Map properties = (Map)mappings.get("properties");
                Object dynamic = mappings.get("dynamic");
                indexMapping = new IndexMapping.Builder().indexName(indexDescriptor.getIndexName()).dynamic(dynamic == null ? "strict" : dynamic.toString()).properties(properties.entrySet().stream().map(IndexMappingProperty::createIndexMappingProperty).collect(Collectors.toSet())).build();
                if (mappingsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (mappingsStream != null) {
                        try {
                            mappingsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchExporterException(String.format("Failed to parse index json [%s]", indexDescriptor.getMappingsClasspathFilename()), e);
                }
            }
            mappingsStream.close();
        }
        return indexMapping;
    }

    private void createIndexTemplate(IndexTemplateDescriptor templateDescriptor) {
        Integer templateReplicas = this.elasticsearchProperties.getReplicasByIndexName().getOrDefault(templateDescriptor.getIndexName(), this.elasticsearchProperties.getDefaultSettings().getNumberOfReplicas());
        Integer templateShards = this.elasticsearchProperties.getShardsByIndexName().getOrDefault(templateDescriptor.getIndexName(), this.elasticsearchProperties.getDefaultSettings().getNumberOfShards());
        ElasticsearchProperties.IndexSettings settings = new ElasticsearchProperties.IndexSettings();
        settings.setNumberOfShards(templateShards);
        settings.setNumberOfReplicas(templateReplicas);
        this.elasticsearchClient.createIndexTemplate(templateDescriptor, settings, false);
    }
}

