/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.schema;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.mapping.DynamicMapping;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.IndexTemplateSummary;
import co.elastic.clients.elasticsearch.indices.PutIndexTemplateRequest;
import co.elastic.clients.elasticsearch.indices.PutMappingRequest;
import co.elastic.clients.elasticsearch.indices.get_index_template.IndexTemplateItem;
import co.elastic.clients.elasticsearch.indices.get_mapping.IndexMappingRecord;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.exporter.config.ElasticsearchProperties;
import io.camunda.exporter.exceptions.ElasticsearchExporterException;
import io.camunda.exporter.exceptions.IndexSchemaValidationException;
import io.camunda.exporter.schema.IndexMapping;
import io.camunda.exporter.schema.IndexMappingProperty;
import io.camunda.exporter.schema.SearchEngineClient;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.webapps.schema.descriptors.IndexTemplateDescriptor;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchEngineClient
implements SearchEngineClient {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchEngineClient.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ElasticsearchClient client;

    public ElasticsearchEngineClient(ElasticsearchClient client) {
        this.client = client;
    }

    @Override
    public void createIndex(IndexDescriptor indexDescriptor) {
        CreateIndexRequest request = this.createIndexRequest(indexDescriptor);
        try {
            this.client.indices().create(request);
            LOG.debug("Index [{}] was successfully created", (Object)indexDescriptor.getIndexName());
        }
        catch (IOException e) {
            String errMsg = String.format("Index [%s] was not created", indexDescriptor.getIndexName());
            LOG.error(errMsg, (Throwable)e);
            throw new ElasticsearchExporterException(errMsg, e);
        }
    }

    @Override
    public void createIndexTemplate(IndexTemplateDescriptor templateDescriptor, ElasticsearchProperties.IndexSettings settings, boolean create) {
        PutIndexTemplateRequest request = this.putIndexTemplateRequest(templateDescriptor, settings, create);
        try {
            this.client.indices().putIndexTemplate(request);
            LOG.debug("Template [{}] was successfully created", (Object)templateDescriptor.getTemplateName());
        }
        catch (IOException e) {
            String errMsg = String.format("Template [%s] was NOT created", templateDescriptor.getTemplateName());
            LOG.error(errMsg, (Throwable)e);
            throw new ElasticsearchExporterException(errMsg, e);
        }
    }

    @Override
    public void putMapping(IndexDescriptor indexDescriptor, Set<IndexMappingProperty> newProperties) {
        PutMappingRequest request = this.putMappingRequest(indexDescriptor, newProperties);
        try {
            this.client.indices().putMapping(request);
            LOG.debug("Mapping in [{}] was successfully updated", (Object)indexDescriptor.getIndexName());
        }
        catch (IOException e) {
            String errMsg = String.format("Mapping in [%s] was NOT updated", indexDescriptor.getIndexName());
            LOG.error(errMsg, (Throwable)e);
            throw new ElasticsearchExporterException(errMsg, e);
        }
    }

    @Override
    public Map<String, IndexMapping> getMappings(String namePattern, MappingSource mappingSource) {
        try {
            Map<String, TypeMapping> mappings = this.getCurrentMappings(mappingSource, namePattern);
            return mappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                TypeMapping mappingsBlock = (TypeMapping)entry.getValue();
                return new IndexMapping.Builder().indexName((String)entry.getKey()).dynamic(this.dynamicFromMappings(mappingsBlock)).properties(this.propertiesFromMappings(mappingsBlock)).metaProperties(this.metaFromMappings(mappingsBlock)).build();
            }));
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException(String.format("Failed retrieving mappings from index/index templates with pattern [%s]", namePattern), e);
        }
    }

    private Map<String, TypeMapping> getCurrentMappings(MappingSource mappingSource, String namePattern) throws IOException {
        if (mappingSource == MappingSource.INDEX) {
            return this.client.indices().getMapping(req -> req.index(namePattern, new String[0])).result().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexMappingRecord)e.getValue()).mappings()));
        }
        if (mappingSource == MappingSource.INDEX_TEMPLATE) {
            return this.client.indices().getIndexTemplate(req -> req.name(namePattern)).indexTemplates().stream().filter(indexTemplateItem -> indexTemplateItem.indexTemplate().template() != null).collect(Collectors.toMap(IndexTemplateItem::name, item -> item.indexTemplate().template().mappings()));
        }
        throw new IndexSchemaValidationException("Invalid mapping source provided must be either INDEX or INDEX_TEMPLATE");
    }

    private Set<IndexMappingProperty> propertiesFromMappings(TypeMapping mapping) {
        return mapping.properties().entrySet().stream().map(p -> new IndexMappingProperty.Builder().name((String)p.getKey()).typeDefinition(Map.of("type", ((Property)p.getValue())._kind().jsonValue())).build()).collect(Collectors.toSet());
    }

    private String dynamicFromMappings(TypeMapping mapping) {
        DynamicMapping dynamic = mapping.dynamic();
        return dynamic == null ? "strict" : dynamic.toString().toLowerCase();
    }

    private Map<String, Object> metaFromMappings(TypeMapping mapping) {
        return mapping.meta().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ent -> ((JsonData)ent.getValue()).to(Object.class)));
    }

    private PutMappingRequest putMappingRequest(IndexDescriptor indexDescriptor, Set<IndexMappingProperty> newProperties) {
        return ((PutMappingRequest.Builder)new PutMappingRequest.Builder().index(indexDescriptor.getIndexName(), new String[0]).withJson(IndexMappingProperty.toPropertiesJson(newProperties, MAPPER))).build();
    }

    public <T> T deserializeJson(JsonpDeserializer<T> deserializer, InputStream json) {
        try (JsonParser parser = this.client._jsonpMapper().jsonProvider().createParser(json);){
            Object object = deserializer.deserialize(parser, this.client._jsonpMapper());
            return (T)object;
        }
    }

    private InputStream getResourceAsStream(String classpathFileName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFileName);
    }

    private PutIndexTemplateRequest putIndexTemplateRequest(IndexTemplateDescriptor indexTemplateDescriptor, ElasticsearchProperties.IndexSettings settings, Boolean create) {
        PutIndexTemplateRequest putIndexTemplateRequest;
        block8: {
            InputStream templateMappings = this.getResourceAsStream(indexTemplateDescriptor.getMappingsClasspathFilename());
            try {
                putIndexTemplateRequest = new PutIndexTemplateRequest.Builder().name(indexTemplateDescriptor.getTemplateName()).indexPatterns(indexTemplateDescriptor.getIndexPattern(), new String[0]).template(t -> t.aliases(indexTemplateDescriptor.getAlias(), Alias.of(a -> a)).mappings(((IndexTemplateSummary)this.deserializeJson(IndexTemplateSummary._DESERIALIZER, templateMappings)).mappings()).settings(s -> s.index(i -> i.numberOfShards(String.valueOf(settings.getNumberOfShards())).numberOfReplicas(String.valueOf(settings.getNumberOfReplicas()))))).composedOf(indexTemplateDescriptor.getComposedOf()).create(create).build();
                if (templateMappings == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (templateMappings != null) {
                        try {
                            templateMappings.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchExporterException("Failed to load file " + indexTemplateDescriptor.getMappingsClasspathFilename() + " from classpath.", e);
                }
            }
            templateMappings.close();
        }
        return putIndexTemplateRequest;
    }

    private CreateIndexRequest createIndexRequest(IndexDescriptor indexDescriptor) {
        CreateIndexRequest createIndexRequest;
        block8: {
            InputStream templateMappings = this.getResourceAsStream(indexDescriptor.getMappingsClasspathFilename());
            try {
                createIndexRequest = new CreateIndexRequest.Builder().index(indexDescriptor.getFullQualifiedName()).aliases(indexDescriptor.getAlias(), a -> a.isWriteIndex(Boolean.valueOf(false))).mappings(((IndexTemplateSummary)this.deserializeJson(IndexTemplateSummary._DESERIALIZER, templateMappings)).mappings()).build();
                if (templateMappings == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (templateMappings != null) {
                        try {
                            templateMappings.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchExporterException("Failed to load file " + indexDescriptor.getMappingsClasspathFilename() + " from classpath.", e);
                }
            }
            templateMappings.close();
        }
        return createIndexRequest;
    }

    public static enum MappingSource {
        INDEX,
        INDEX_TEMPLATE;

    }
}

