/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.handlers;

import io.camunda.exporter.entities.UserEntity;
import io.camunda.exporter.exceptions.PersistenceException;
import io.camunda.exporter.handlers.ExportHandler;
import io.camunda.exporter.store.BatchRequest;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.value.UserRecordValue;
import java.util.List;

public class UserRecordValueExportHandler
implements ExportHandler<UserEntity, UserRecordValue> {
    @Override
    public ValueType getHandledValueType() {
        return ValueType.USER;
    }

    @Override
    public Class<UserEntity> getEntityType() {
        return UserEntity.class;
    }

    @Override
    public boolean handlesRecord(Record<UserRecordValue> record) {
        return this.getHandledValueType().equals((Object)record.getValueType());
    }

    @Override
    public List<String> generateIds(Record<UserRecordValue> record) {
        return List.of(String.valueOf(record.getKey()));
    }

    @Override
    public UserEntity createNewEntity(String id) {
        return new UserEntity().setId(id);
    }

    @Override
    public void updateEntity(Record<UserRecordValue> record, UserEntity entity) {
        UserRecordValue value = (UserRecordValue)record.getValue();
        entity.setKey(value.getUserKey()).setUsername(value.getUsername()).setName(value.getName()).setEmail(value.getEmail()).setPassword(value.getPassword());
    }

    @Override
    public void flush(UserEntity entity, BatchRequest batchRequest) throws PersistenceException {
        batchRequest.add(this.getIndexName(), entity);
    }

    private String getIndexName() {
        return "users";
    }
}

