/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.handlers;

import io.camunda.exporter.entities.AuthorizationEntity;
import io.camunda.exporter.exceptions.PersistenceException;
import io.camunda.exporter.handlers.ExportHandler;
import io.camunda.exporter.store.BatchRequest;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.value.AuthorizationRecordValue;
import io.camunda.zeebe.protocol.record.value.PermissionType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AuthorizationRecordValueExportHandler
implements ExportHandler<AuthorizationEntity, AuthorizationRecordValue> {
    @Override
    public ValueType getHandledValueType() {
        return ValueType.AUTHORIZATION;
    }

    @Override
    public Class<AuthorizationEntity> getEntityType() {
        return AuthorizationEntity.class;
    }

    @Override
    public boolean handlesRecord(Record<AuthorizationRecordValue> record) {
        return this.getHandledValueType().equals((Object)record.getValueType());
    }

    @Override
    public List<String> generateIds(Record<AuthorizationRecordValue> record) {
        return List.of(String.valueOf(record.getKey()));
    }

    @Override
    public AuthorizationEntity createNewEntity(String id) {
        return new AuthorizationEntity().setId(id);
    }

    @Override
    public void updateEntity(Record<AuthorizationRecordValue> record, AuthorizationEntity entity) {
        AuthorizationRecordValue value = (AuthorizationRecordValue)record.getValue();
        entity.setOwnerKey(value.getOwnerKey()).setOwnerType(value.getOwnerType()).setResourceType(value.getResourceType()).setPermissionValues(this.getPermissionMap(value.getPermissions()));
    }

    @Override
    public void flush(AuthorizationEntity entity, BatchRequest batchRequest) throws PersistenceException {
        batchRequest.add(this.getIndexName(), entity);
    }

    private String getIndexName() {
        return "authorizations";
    }

    private Map<PermissionType, List<String>> getPermissionMap(List<AuthorizationRecordValue.PermissionValue> permissionValues) {
        return permissionValues.stream().collect(Collectors.toMap(AuthorizationRecordValue.PermissionValue::getPermissionType, AuthorizationRecordValue.PermissionValue::getResourceIds));
    }
}

