/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.exporter.clients.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.google.common.base.Strings;
import io.camunda.exporter.config.ElasticsearchProperties;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticsearchClientFactory {
    public static final ElasticsearchClientFactory INSTANCE = new ElasticsearchClientFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchClientFactory.class);

    private ElasticsearchClientFactory() {
    }

    public ElasticsearchClient create(ElasticsearchProperties elsConfig) {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{this.getHttpHost(elsConfig)});
        restClientBuilder.setRequestConfigCallback(configCallback -> this.setTimeouts(configCallback, elsConfig));
        RestClient restClient = restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> this.configureHttpClient(httpClientBuilder, elsConfig)).build();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
        ElasticsearchClient elasticsearchClient = new ElasticsearchClient((ElasticsearchTransport)transport);
        if (this.checkHealth(elasticsearchClient, elsConfig)) {
            LOGGER.debug("Elasticsearch connection was successfully created.");
        }
        return elasticsearchClient;
    }

    public boolean checkHealth(ElasticsearchClient elasticsearchClient, ElasticsearchProperties elsConfig) {
        try {
            HealthResponse healthResponse = elasticsearchClient.cluster().health();
            LOGGER.info("Elasticsearch cluster health: {}", (Object)healthResponse.status());
            return healthResponse.clusterName().equals(elsConfig.getClusterName());
        }
        catch (Exception e) {
            LOGGER.warn("Elasticsearch cluster is not accessible", (Throwable)e);
            return false;
        }
    }

    private HttpAsyncClientBuilder configureHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder, ElasticsearchProperties elsConfig) {
        this.setupAuthentication(httpAsyncClientBuilder, elsConfig);
        return httpAsyncClientBuilder;
    }

    private void setupAuthentication(HttpAsyncClientBuilder builder, ElasticsearchProperties elsConfig) {
        String username = elsConfig.getUsername();
        String password = elsConfig.getPassword();
        if (Strings.isNullOrEmpty((String)username) || Strings.isNullOrEmpty((String)password)) {
            LOGGER.warn("Username and/or password for are empty. Basic authentication for elasticsearch is not used.");
            return;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    private HttpHost getHttpHost(ElasticsearchProperties elsConfig) {
        return HttpHost.create((String)elsConfig.getUrl());
    }

    private RequestConfig.Builder setTimeouts(RequestConfig.Builder builder, ElasticsearchProperties elsConfig) {
        if (elsConfig.getSocketTimeout() != null) {
            builder.setSocketTimeout(elsConfig.getSocketTimeout().intValue());
        }
        if (elsConfig.getConnectTimeout() != null) {
            builder.setConnectTimeout(elsConfig.getConnectTimeout().intValue());
        }
        return builder;
    }
}

