/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.ProcessInstanceFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.ProcessInstanceSearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.ProcessInstanceSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.ProcessInstanceSearchQuery;
import io.camunda.client.protocol.rest.ProcessInstanceSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessInstanceSearchRequestImpl
extends TypedSearchRequestPropertyProvider<ProcessInstanceSearchQuery>
implements ProcessInstanceSearchRequest {
    private final ProcessInstanceSearchQuery request = new ProcessInstanceSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public ProcessInstanceSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchRequestStep<ProcessInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<ProcessInstance>> send() {
        HttpCamundaFuture<SearchResponse<ProcessInstance>> result = new HttpCamundaFuture<SearchResponse<ProcessInstance>>();
        this.httpClient.post("/process-instances/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), ProcessInstanceSearchQueryResult.class, SearchResponseMapper::toProcessInstanceSearchResponse, result);
        return result;
    }

    @Override
    public ProcessInstanceSearchRequest filter(ProcessInstanceFilter value) {
        this.request.setFilter((io.camunda.client.protocol.rest.ProcessInstanceFilter)ProcessInstanceSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public ProcessInstanceSearchRequest filter(Consumer<ProcessInstanceFilter> fn) {
        return this.filter(SearchRequestBuilders.processInstanceFilter(fn));
    }

    @Override
    public ProcessInstanceSearchRequest sort(ProcessInstanceSort value) {
        this.request.setSort(SearchRequestSortMapper.toProcessInstanceSearchQuerySortRequest((List)ProcessInstanceSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public ProcessInstanceSearchRequest sort(Consumer<ProcessInstanceSort> fn) {
        return this.sort(SearchRequestBuilders.processInstanceSort(fn));
    }

    @Override
    public ProcessInstanceSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)ProcessInstanceSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public ProcessInstanceSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected ProcessInstanceSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

