/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UpdateAuthorizationCommandStep1;
import io.camunda.client.api.response.UpdateAuthorizationResponse;
import io.camunda.client.api.search.enums.OwnerType;
import io.camunda.client.api.search.enums.PermissionType;
import io.camunda.client.api.search.enums.ResourceType;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.UpdateAuthorizationResponseImpl;
import io.camunda.client.impl.util.EnumUtil;
import io.camunda.client.protocol.rest.AuthorizationRequest;
import io.camunda.client.protocol.rest.OwnerTypeEnum;
import io.camunda.client.protocol.rest.PermissionTypeEnum;
import io.camunda.client.protocol.rest.ResourceTypeEnum;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.config.RequestConfig;

public class UpdateAuthorizationCommandImpl
implements UpdateAuthorizationCommandStep1,
UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep2,
UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep3,
UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep4,
UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep5,
UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep6 {
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;
    private final AuthorizationRequest request;
    private final long authorizationKey;

    public UpdateAuthorizationCommandImpl(HttpClient httpClient, JsonMapper jsonMapper, long authorizationKey) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new AuthorizationRequest();
        this.authorizationKey = authorizationKey;
    }

    @Override
    public UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep2 ownerId(String ownerId) {
        ArgumentUtil.ensureNotNullNorEmpty("ownerId", ownerId);
        this.request.setOwnerId(ownerId);
        return this;
    }

    @Override
    public UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep3 ownerType(OwnerType ownerType) {
        ArgumentUtil.ensureNotNull("ownerType", (Object)ownerType);
        this.request.setOwnerType(EnumUtil.convert(ownerType, OwnerTypeEnum.class));
        return this;
    }

    @Override
    public UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep4 resourceId(String resourceId) {
        ArgumentUtil.ensureNotNullNorEmpty("resourceId", resourceId);
        this.request.setResourceId(resourceId);
        return this;
    }

    @Override
    public UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep5 resourceType(ResourceType resourceType) {
        ArgumentUtil.ensureNotNull("resourceType", (Object)resourceType);
        this.request.setResourceType(EnumUtil.convert(resourceType, ResourceTypeEnum.class));
        return this;
    }

    @Override
    public UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep6 permissionTypes(PermissionType ... permissionTypes) {
        ArgumentUtil.ensureNotNull("permissionTypes", permissionTypes);
        this.request.setPermissionTypes(Arrays.stream(permissionTypes).map(permissionType -> EnumUtil.convert(permissionType, PermissionTypeEnum.class)).collect(Collectors.toList()));
        return this;
    }

    @Override
    public FinalCommandStep<UpdateAuthorizationResponse> requestTimeout(Duration requestTimeout) {
        ArgumentUtil.ensurePositive("requestTimeout", requestTimeout);
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UpdateAuthorizationResponse> send() {
        HttpCamundaFuture<UpdateAuthorizationResponse> result = new HttpCamundaFuture<UpdateAuthorizationResponse>();
        this.httpClient.put("/authorizations/" + this.authorizationKey, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), UpdateAuthorizationResponseImpl::new, result);
        return result;
    }
}

