/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.ExperimentalApi;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CreateDocumentCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.DocumentReferenceResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.DocumentReferenceResponseImpl;
import io.camunda.client.impl.util.DocumentBuilder;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.DocumentReference;
import java.io.InputStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalApi(value="https://github.com/camunda/issues/issues/841")
public class CreateDocumentCommandImpl
extends DocumentBuilder
implements CreateDocumentCommandStep1,
CreateDocumentCommandStep1.CreateDocumentCommandStep2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateDocumentCommandImpl.class);
    private String documentId;
    private String storeId;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CreateDocumentCommandImpl(JsonMapper jsonMapper, HttpClient httpClient, CamundaClientConfiguration configuration) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.requestTimeout(configuration.getDefaultRequestTimeout());
    }

    @Override
    public FinalCommandStep<DocumentReferenceResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CamundaFuture<DocumentReferenceResponse> send() {
        try {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA);
            String name = this.getMetadata().getFileName();
            entityBuilder.addBinaryBody("file", this.getContent(), ContentType.DEFAULT_BINARY, name);
            String metadataString = this.jsonMapper.toJson(this.getMetadata());
            entityBuilder.addPart("metadata", (ContentBody)new StringBody(metadataString, ContentType.APPLICATION_JSON));
            HttpCamundaFuture<DocumentReferenceResponse> result = new HttpCamundaFuture<DocumentReferenceResponse>();
            HashMap<String, String> queryParams = new HashMap<String, String>();
            if (this.documentId != null) {
                queryParams.put("documentId", this.documentId);
            }
            if (this.storeId != null) {
                queryParams.put("storeId", this.storeId);
            }
            this.httpClient.postMultipart("/documents", queryParams, entityBuilder, this.httpRequestConfig.build(), DocumentReference.class, DocumentReferenceResponseImpl::new, result);
            HttpCamundaFuture<DocumentReferenceResponse> httpCamundaFuture = result;
            return httpCamundaFuture;
        }
        finally {
            try {
                this.getContent().close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close content stream", (Throwable)e);
            }
        }
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 content(InputStream content) {
        super.content(content);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 content(byte[] content) {
        super.content(content);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 content(String content) {
        super.content(content);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 contentType(String contentType) {
        super.contentType(contentType);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 fileName(String name) {
        super.fileName(name);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 timeToLive(Duration timeToLive) {
        super.timeToLive(timeToLive);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 customMetadata(String key, Object value) {
        super.customMetadata(key, value);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 customMetadata(Map<String, Object> customMetadata) {
        super.customMetadata(customMetadata);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 processDefinitionId(String processDefinitionId) {
        super.getMetadata().setProcessDefinitionId(processDefinitionId);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 processInstanceKey(long processInstanceKey) {
        super.getMetadata().setProcessInstanceKey(ParseUtil.keyToString(processInstanceKey));
        return this;
    }
}

