/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.http;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.http.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Client {
    private String url;
    private String accessToken;
    private String authorization;
    private HttpClient client = null;
    private static String version = "dev";
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private static final int OK = 200;
    private static final int NOT_MODIFIED = 304;
    private static final int BAD_REQUEST = 400;
    private static final int NOT_AUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int NOT_ACCEPTABLE = 406;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int BAD_GATEWAY = 502;
    private static final int SERVICE_UNAVAILABLE = 503;
    private static final boolean DEBUG = true;
    private static final String JSON = new String("application/json; charset=utf-8");
    private static final String UTF_8 = "UTF-8";
    private static Logger log = Logger.getLogger((String)Client.class.getName());

    public Client() throws BytomException {
        this(150, 30000, 30000);
        this.url = "http://127.0.0.1:9888";
    }

    public Client(String url) {
        this(150, 30000, 30000);
        this.url = url;
    }

    public Client(String url, String accessToken) {
        this(150, 30000, 30000);
        this.url = url;
        this.accessToken = accessToken;
        this.initAuthorization();
    }

    private void initAuthorization() {
        String[] as;
        if (StringUtils.isNotEmpty((CharSequence)this.accessToken) && (as = this.accessToken.split(":")).length == 2) {
            String username = as[0];
            String password = as[1];
            String encoding = "";
            try {
                encoding = new String(Base64.encodeBase64((byte[])(username + ":" + password).getBytes(UTF_8)));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.authorization = "Basic " + encoding;
        }
    }

    public Client(int maxConPerHost, int conTimeOutMs, int soTimeOutMs) {
        HttpConnectionManagerParams params = this.connectionManager.getParams();
        params.setDefaultMaxConnectionsPerHost(maxConPerHost);
        params.setConnectionTimeout(conTimeOutMs);
        params.setSoTimeout(soTimeOutMs);
        HttpClientParams clientParams = new HttpClientParams();
        this.client = new HttpClient(clientParams, (HttpConnectionManager)this.connectionManager);
    }

    public boolean request(String action, Object body) throws BytomException {
        ResponseCreator<Boolean> rc = new ResponseCreator<Boolean>(){

            @Override
            public Boolean create(Response response, Gson deserializer) throws IOException, BytomException {
                JsonElement root = new JsonParser().parse(response.asString());
                JsonElement status = root.getAsJsonObject().get("status");
                if (status != null && status.toString().contains("fail")) {
                    throw new BytomException(root.getAsJsonObject().get("msg").toString());
                }
                if (status != null && status.toString().contains("success")) {
                    return true;
                }
                return false;
            }
        };
        return this.post(action, body, rc);
    }

    public <T> T request(String action, Object body, final Type tClass) throws BytomException {
        ResponseCreator rc = new ResponseCreator<T>(){

            @Override
            public T create(Response response, Gson deserializer) throws IOException, BytomException {
                JsonElement root = new JsonParser().parse(response.asString());
                JsonElement status = root.getAsJsonObject().get("status");
                JsonElement data = root.getAsJsonObject().get("data");
                if (status != null && status.toString().contains("fail")) {
                    throw new BytomException(root.getAsJsonObject().get("msg").toString());
                }
                if (data != null) {
                    return deserializer.fromJson(data, tClass);
                }
                return deserializer.fromJson(response.asString(), tClass);
            }
        };
        return this.post(action, body, rc);
    }

    public <T> T requestGet(String action, Object body, final String key, final Type tClass) throws BytomException {
        ResponseCreator rc = new ResponseCreator<T>(){

            @Override
            public T create(Response response, Gson deserializer) throws IOException, BytomException {
                JsonElement root = new JsonParser().parse(response.asString());
                JsonElement status = root.getAsJsonObject().get("status");
                JsonElement data = root.getAsJsonObject().get("data");
                if (status != null && status.toString().contains("fail")) {
                    throw new BytomException(root.getAsJsonObject().get("msg").toString());
                }
                if (data != null) {
                    return deserializer.fromJson(data.getAsJsonObject().get(key), tClass);
                }
                return deserializer.fromJson(response.asString(), tClass);
            }
        };
        return this.post(action, body, rc);
    }

    public <T> T requestList(String action, Object body, final Type tClass) throws BytomException {
        ResponseCreator rc = new ResponseCreator<T>(){

            @Override
            public T create(Response response, Gson deserializer) throws IOException, BytomException {
                JsonElement root = new JsonParser().parse(response.asString());
                JsonElement status = root.getAsJsonObject().get("status");
                if (status != null && status.toString().contains("fail")) {
                    throw new BytomException(root.getAsJsonObject().get("msg").toString());
                }
                return deserializer.fromJson(response.asString(), tClass);
            }
        };
        return this.post(action, body, rc);
    }

    private <T> T post(String action, Object body, ResponseCreator<T> respCreator) throws BytomException {
        Client.log("Request:");
        Client.log("Action:" + action);
        int responseCode = -1;
        String content = Utils.serializer.toJson(body);
        PostMethod postMethod = new PostMethod(this.url + action);
        try {
            HttpMethodParams param = postMethod.getParams();
            param.setContentCharset(UTF_8);
            postMethod.setRequestHeader("Content-Type", JSON);
            StringRequestEntity requestEntity = null;
            requestEntity = new StringRequestEntity(content, "application/x-www-form-urlencoded", UTF_8);
            postMethod.setRequestEntity((RequestEntity)requestEntity);
            ArrayList<Header> headers = new ArrayList<Header>();
            headers.add(new Header("User-Agent", "bytom-sdk-java-" + version));
            if (this.authorization != null) {
                headers.add(new Header("Authorization", this.authorization));
            }
            this.client.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
            for (Header header : headers) {
                Client.log(header.getName() + ": " + header.getValue());
            }
            postMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            this.client.executeMethod((HttpMethod)postMethod);
            Header[] resHeader = postMethod.getResponseHeaders();
            responseCode = postMethod.getStatusCode();
            Client.log("Response:");
            Client.log("https StatusCode:" + String.valueOf(responseCode));
            for (Header header : resHeader) {
                Client.log(header.getName() + ":" + header.getValue());
            }
            Response response = new Response();
            response.setResponseAsString(postMethod.getResponseBodyAsString());
            Client.log(response.toString() + "\n");
            if (responseCode != 200) {
                throw new BytomException(Client.getCause(responseCode), response.toString(), postMethod.getStatusCode());
            }
            T t = respCreator.create(response, Utils.serializer);
            return t;
        }
        catch (IOException ioe) {
            throw new BytomException(ioe.getMessage(), ioe, responseCode);
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    private static String getCause(int statusCode) {
        String cause = null;
        switch (statusCode) {
            case 304: {
                break;
            }
            case 400: {
                cause = "The request was invalid.  An accompanying error message will explain why. This is the status code will be returned during rate limiting.";
                break;
            }
            case 401: {
                cause = "Authentication credentials were missing or incorrect.";
                break;
            }
            case 403: {
                cause = "The request is understood, but it has been refused.  ";
                break;
            }
            case 404: {
                cause = "The URI requested is invalid or the resource requested.";
                break;
            }
            case 406: {
                cause = "Returned by the Search API when an invalid format is specified in the request.";
                break;
            }
            case 500: {
                cause = "Something is broken.  Please post to the group so the Bytom team can investigate.";
                break;
            }
            case 502: {
                cause = "Bytom is down or being upgraded.";
                break;
            }
            case 503: {
                cause = "Service Unavailable: The Bytom servers are up, but overloaded with requests. Try again later. The search and trend methods use this to indicate when you are being rate limited.";
                break;
            }
            default: {
                cause = "";
            }
        }
        return statusCode + ":" + cause;
    }

    private static void log(String message) {
        log.debug((Object)message);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public static interface ResponseCreator<T> {
        public T create(Response var1, Gson var2) throws BytomException, IOException;
    }
}

