/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.api.BlockTx;
import io.bytom.exception.BytomException;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.List;

public class Block {
    public String hash;
    public long size;
    public long version;
    public long height;
    @SerializedName(value="previous_block_hash")
    public String previousBlockHash;
    public long timestamp;
    public long nonce;
    public long bits;
    public String difficulty;
    @SerializedName(value="transaction_merkle_root")
    public String transactionsMerkleRoot;
    @SerializedName(value="transaction_status_hash")
    public String transactionStatusHash;
    public List<BlockTx> transactions;

    public static int getBlockCount(Client client) throws BytomException {
        return (Integer)client.requestGet("get-block-count", null, "block_count", (Type)((Object)Integer.class));
    }

    public static String getBlockHash(Client client) throws BytomException {
        return (String)client.requestGet("get-block-hash", null, "block_hash", (Type)((Object)String.class));
    }

    public String toString() {
        return "Block [hash=" + this.hash + ", size=" + this.size + ", version=" + this.version + ", height=" + this.height + ", previousBlockHash=" + this.previousBlockHash + ", timestamp=" + this.timestamp + ", nonce=" + this.nonce + ", bits=" + this.bits + ", difficulty=" + this.difficulty + ", transactionsMerkleRoot=" + this.transactionsMerkleRoot + ", transactionStatusHash=" + this.transactionStatusHash + ", transactions=" + this.transactions + "]";
    }

    public static class BlockHashRate {
        public String hash;
        public long height;
        public long hash_rate;
    }

    public static class BlockDifficulty {
        public String hash;
        public long height;
        public long bits;
        public long difficulty;
    }

    public static class BlockHeader {
        @SerializedName(value="block_header")
        public String blockHeader;
        public long reward;
    }

    public static class QueryBuilder {
        @SerializedName(value="block_height")
        public int blockHeight;
        public String blockHash;

        public QueryBuilder setBlockHeight(int blockHeight) {
            this.blockHeight = blockHeight;
            return this;
        }

        public QueryBuilder setBlockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public Block getBlock(Client client) throws BytomException {
            return (Block)client.request("get-block", this, (Type)((Object)Block.class));
        }

        public BlockHeader getBlockHeader(Client client) throws BytomException {
            return (BlockHeader)client.request("get-block-header", this, (Type)((Object)BlockHeader.class));
        }

        public BlockDifficulty getBlockDifficulty(Client client) throws BytomException {
            return (BlockDifficulty)client.request("get-difficulty", this, (Type)((Object)BlockDifficulty.class));
        }

        public BlockHashRate getHashRate(Client client) throws BytomException {
            return (BlockHashRate)client.request("get-hash-rate", this, (Type)((Object)BlockHashRate.class));
        }
    }
}

