/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.exception.BytomException;
import io.bytom.http.BytomResponse;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Asset {
    public String id;
    public String alias;
    @SerializedName(value="issuance_program", alternate={"issue_program"})
    public String issuanceProgram;
    public Key[] keys;
    @SerializedName(value="key_index")
    public Integer keyIndex;
    public int quorum;
    @SerializedName(value="xpubs")
    public List<String> xpubs;
    public String type;
    public int vm_version;
    public String raw_definition_byte;
    public Map<String, Object> definition;

    public static class UpdateBuilder {
        public String id;
        public String alias;

        public UpdateBuilder setAssetId(String assetId) {
            this.id = assetId;
            return this;
        }

        public UpdateBuilder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public boolean update(Client client) throws BytomException {
            return client.request("update-asset-alias", this);
        }
    }

    public static class Items
    extends BytomResponse<Asset> {
        public Items query() throws BytomException {
            Items items = (Items)this.client.requestList("list-assets", null, (Type)((Object)Items.class));
            items.setClient(this.client);
            return items;
        }
    }

    public static class QueryBuilder {
        public String id;

        public QueryBuilder setAssetId(String assetId) {
            this.id = assetId;
            return this;
        }

        public Asset get(Client client) throws BytomException {
            return (Asset)client.request("get-asset", this, (Type)((Object)Asset.class));
        }

        public Items list(Client client) throws BytomException {
            Items items = new Items();
            items.setClient(client);
            return items.query();
        }
    }

    public static class Builder {
        @SerializedName(value="root_xpubs")
        public List<String> rootXpubs = new ArrayList<String>();
        public String alias;
        public int quorum;
        public Map<String, Object> definition;
        @SerializedName(value="access_token")
        private String access_token;

        public Asset create(Client client) throws BytomException {
            return (Asset)client.request("create-asset", this, (Type)((Object)Asset.class));
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder addDefinitionField(String key, Object value) {
            if (this.definition == null) {
                this.definition = new HashMap<String, Object>();
            }
            this.definition.put(key, value);
            return this;
        }

        public Builder setDefinition(Map<String, Object> definition) {
            this.definition = definition;
            return this;
        }

        public Builder setQuorum(int quorum) {
            this.quorum = quorum;
            return this;
        }

        public Builder addRootXpub(String xpub) {
            this.rootXpubs.add(xpub);
            return this;
        }

        public Builder setRootXpubs(List<String> xpubs) {
            this.rootXpubs = new ArrayList<String>(xpubs);
            return this;
        }
    }

    public static class Key {
        @SerializedName(value="root_xpub")
        public String rootXpub;
        @SerializedName(value="asset_pubkey")
        public String assetPubkey;
        @SerializedName(value="asset_derivation_path")
        public String[] assetDerivationPath;
    }
}

