/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.vertx;

import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.RuntimeConfiguration;
import io.burt.jmespath.jcf.JcfRuntime;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class VertxRuntime
extends JcfRuntime {
    public VertxRuntime() {
        this(RuntimeConfiguration.defaultConfiguration());
    }

    public VertxRuntime(RuntimeConfiguration configuration) {
        super(configuration);
    }

    public Object parseString(String str) {
        return Json.decodeValue((String)str);
    }

    public List<Object> toList(final Object value) {
        if (value instanceof JsonArray) {
            final JsonArray ja = (JsonArray)value;
            return new AbstractList<Object>(){

                @Override
                public int size() {
                    return ja.size();
                }

                @Override
                public Object get(int i) {
                    return ja.getValue(i);
                }
            };
        }
        if (value instanceof JsonObject) {
            return new AbstractList<Object>(){
                private List<Object> cache = null;

                @Override
                public int size() {
                    return ((JsonObject)value).size();
                }

                @Override
                public Object get(int i) {
                    if (this.cache == null) {
                        ArrayList<Object> list = new ArrayList<Object>(this.size());
                        for (Map.Entry entry : (JsonObject)value) {
                            list.add(entry.getValue());
                        }
                        this.cache = list;
                    }
                    return this.cache.get(i);
                }
            };
        }
        return Collections.EMPTY_LIST;
    }

    public String toString(Object value) {
        if (value instanceof JsonArray || value instanceof JsonObject) {
            return value.toString();
        }
        return super.toString(value);
    }

    public boolean isTruthy(Object value) {
        switch (this.typeOf(value)) {
            case OBJECT: {
                return !((JsonObject)value).isEmpty();
            }
            case ARRAY: {
                return !((JsonArray)value).isEmpty();
            }
        }
        return super.isTruthy(value);
    }

    public JmesPathType typeOf(Object value) {
        if (value instanceof JsonObject) {
            return JmesPathType.OBJECT;
        }
        if (value instanceof JsonArray) {
            return JmesPathType.ARRAY;
        }
        if (value instanceof Collection || value instanceof Map) {
            throw new IllegalStateException(String.format("Unknown node type encountered: %s", value.getClass().getName()));
        }
        return super.typeOf(value);
    }

    public Object getProperty(Object value, Object name) {
        if (value instanceof JsonObject && name instanceof String) {
            return ((JsonObject)value).getValue((String)name);
        }
        return null;
    }

    public Collection<Object> getPropertyNames(Object value) {
        if (value instanceof JsonObject) {
            JsonObject jo = (JsonObject)value;
            return jo.getMap().keySet();
        }
        return Collections.EMPTY_LIST;
    }

    public Object createArray(Collection<Object> elements) {
        JsonArray ja = new JsonArray();
        for (Object element : elements) {
            ja.add(element);
        }
        return ja;
    }

    public Object createObject(Map<Object, Object> obj) {
        JsonObject jo = new JsonObject();
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            jo.put((String)entry.getKey(), entry.getValue());
        }
        return jo;
    }

    public int compare(Object value1, Object value2) {
        switch (this.typeOf(value1)) {
            case OBJECT: 
            case ARRAY: {
                return value1.equals(value2) ? 0 : -1;
            }
        }
        return super.compare(value1, value2);
    }
}

