/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.internal_api.ClassDefiner;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassDefiners {
    private static final Logger log = LoggerFactory.getLogger(ClassDefiners.class);
    private static volatile ClassDefiner CACHED;

    private ClassDefiners() {
    }

    public static ClassDefiner best() {
        Method privateLookupIn;
        Class<?> lookupClz2;
        ClassDefiner local = CACHED;
        if (local != null) {
            return local;
        }
        try {
            lookupClz2 = MethodHandles.lookup().getClass();
            Class<MethodHandles> mhClz = MethodHandles.class;
            privateLookupIn = mhClz.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            Class<?> classOption = Class.forName("java.lang.invoke.MethodHandles$Lookup$ClassOption");
            Method defineHiddenClass = lookupClz2.getMethod("defineHiddenClass", byte[].class, Boolean.TYPE, Array.newInstance(classOption, 0).getClass());
            if (privateLookupIn != null && defineHiddenClass != null) {
                CACHED = local = new HiddenDefiner();
                if (log.isDebugEnabled()) {
                    log.debug("Using class definer (auto): {}", (Object)local.name());
                }
                return local;
            }
        }
        catch (Throwable lookupClz2) {
            // empty catch block
        }
        try {
            lookupClz2 = MethodHandles.lookup().getClass();
            Method defineClass = lookupClz2.getMethod("defineClass", byte[].class);
            privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            if (defineClass != null && privateLookupIn != null) {
                CACHED = local = new LookupDefiner();
                if (log.isDebugEnabled()) {
                    log.debug("Using class definer (auto): {}", (Object)local.name());
                }
                return local;
            }
        }
        catch (Throwable lookupClz3) {
            // empty catch block
        }
        try {
            Class<?> unsafeClz = Class.forName("sun.misc.Unsafe");
            Field f = unsafeClz.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object unsafe = f.get(null);
            Method m = unsafeClz.getMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
            if (unsafe != null && m != null) {
                CACHED = local = new UnsafeDefiner(unsafe, m);
                if (log.isDebugEnabled()) {
                    log.debug("Using class definer (auto): {}", (Object)local.name());
                }
                return local;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CACHED = local = new LoaderDefiner();
        if (log.isDebugEnabled()) {
            log.debug("Using class definer (auto): {}", (Object)local.name());
        }
        return local;
    }

    public static ClassDefiner byName(String name) {
        String n;
        switch (n = name.toLowerCase()) {
            case "hidden": {
                return new HiddenDefiner();
            }
            case "lookup": {
                return new LookupDefiner();
            }
            case "unsafe": {
                try {
                    Class<?> unsafeClz = Class.forName("sun.misc.Unsafe");
                    Field f = unsafeClz.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    Object unsafe = f.get(null);
                    Method m = unsafeClz.getMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
                    return new UnsafeDefiner(unsafe, m);
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Unsafe not available", t);
                }
            }
            case "loader": {
                return new LoaderDefiner();
            }
        }
        throw new IllegalArgumentException("Unknown definer: " + name);
    }

    private static final class LoaderDefiner
    implements ClassDefiner {
        LoaderDefiner() {
        }

        @Override
        public String name() {
            return "loader";
        }

        @Override
        public Class<?> define(byte[] bytes, Class<?> host) throws Throwable {
            ClassLoader cl;
            ClassLoader classLoader = cl = host != null ? host.getClassLoader() : ClassLoader.getSystemClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            Method m = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
            return (Class)m.invoke((Object)cl, null, bytes, 0, bytes.length);
        }
    }

    private static final class UnsafeDefiner
    implements ClassDefiner {
        private final Object unsafe;
        private final Method defineAnonymousClass;

        UnsafeDefiner(Object unsafe, Method defineAnonymousClass) {
            this.unsafe = unsafe;
            this.defineAnonymousClass = defineAnonymousClass;
        }

        @Override
        public String name() {
            return "unsafe";
        }

        @Override
        public Class<?> define(byte[] bytes, Class<?> host) throws Throwable {
            return (Class)this.defineAnonymousClass.invoke(this.unsafe, host, bytes, null);
        }
    }

    private static final class LookupDefiner
    implements ClassDefiner {
        LookupDefiner() {
        }

        @Override
        public String name() {
            return "lookup";
        }

        @Override
        public Class<?> define(byte[] bytes, Class<?> host) throws Throwable {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Method privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            Object hostLookup = privateLookupIn.invoke(null, host, lookup);
            Method defineClass = hostLookup.getClass().getMethod("defineClass", byte[].class);
            return (Class)defineClass.invoke(hostLookup, new Object[]{bytes});
        }
    }

    private static final class HiddenDefiner
    implements ClassDefiner {
        HiddenDefiner() {
        }

        @Override
        public String name() {
            return "hidden";
        }

        @Override
        public Class<?> define(byte[] bytes, Class<?> host) throws Throwable {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Method privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            Object hostLookup = privateLookupIn.invoke(null, host, lookup);
            Class<?> lookupClz = hostLookup.getClass();
            Class<?> classOption = Class.forName("java.lang.invoke.MethodHandles$Lookup$ClassOption");
            Object opts = Array.newInstance(classOption, 1);
            Array.set(opts, 0, Enum.valueOf(classOption, "NESTMATE"));
            Method defineHiddenClass = lookupClz.getMethod("defineHiddenClass", byte[].class, Boolean.TYPE, opts.getClass());
            Object hiddenLookup = defineHiddenClass.invoke(hostLookup, bytes, Boolean.TRUE, opts);
            Method lookupClass = hiddenLookup.getClass().getMethod("lookupClass", new Class[0]);
            return (Class)lookupClass.invoke(hiddenLookup, new Object[0]);
        }
    }
}

