/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.location;

import clocker.docker.networking.entity.VirtualNetwork;
import clocker.docker.networking.location.NetworkProvisioningExtension;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.util.net.Cidr;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenStackNetworkProvisioner
implements NetworkProvisioningExtension {
    private static final Logger LOG = LoggerFactory.getLogger(OpenStackNetworkProvisioner.class);
    private final JcloudsLocation location;

    public OpenStackNetworkProvisioner(JcloudsLocation location) {
        this.location = location;
    }

    @Override
    public void provisionNetwork(VirtualNetwork network) {
        String name = (String)network.config().get(VirtualNetwork.NETWORK_ID);
        SecurityGroupExtension extension = (SecurityGroupExtension)this.location.getComputeService().getSecurityGroupExtension().get();
        Set groups = extension.listSecurityGroups();
        String id = null;
        for (SecurityGroup each : groups) {
            if (!each.getName().equalsIgnoreCase(name)) continue;
            id = each.getId();
            break;
        }
        if (id == null) {
            Location region = (Location)this.location.getComputeService().listAssignableLocations().iterator().next();
            SecurityGroup added = extension.createSecurityGroup(name, region);
            id = added.getId();
            IpPermission rules = IpPermission.builder().cidrBlock(((Cidr)network.config().get(VirtualNetwork.NETWORK_CIDR)).toString()).ipProtocol(IpProtocol.TCP).fromPort(1).toPort(65535).build();
            extension.addIpPermission(rules, added);
            LOG.info("Added new security group {} with ID {}: {}", new Object[]{added.getName(), id, rules.toString()});
        }
        network.sensors().set(VirtualNetwork.NETWORK_ID, id);
    }

    @Override
    public Map<String, Cidr> listManagedNetworkAddressSpace() {
        return null;
    }

    @Override
    public void deallocateNetwork(VirtualNetwork network) {
    }
}

