/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn.weave;

import clocker.docker.entity.DockerHost;
import clocker.docker.location.DockerHostLocation;
import clocker.docker.networking.entity.sdn.SdnAgent;
import clocker.docker.networking.entity.sdn.SdnProviderImpl;
import clocker.docker.networking.entity.sdn.weave.WeaveNetwork;
import clocker.docker.networking.entity.sdn.weave.WeaveRouter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeaveNetworkImpl
extends SdnProviderImpl
implements WeaveNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(WeaveNetwork.class);

    @Override
    public void init() {
        LOG.info("Starting Weave network id {}", (Object)this.getId());
        super.init();
        EntitySpec agentSpec = (EntitySpec)((EntitySpec)EntitySpec.create((EntitySpec)((EntitySpec)this.config().get((ConfigKey.HasConfigKey)WEAVE_ROUTER_SPEC))).configure(WeaveRouter.WEAVE_PORT, this.config().get(WeaveNetwork.WEAVE_PORT))).configure((ConfigKey.HasConfigKey)WeaveRouter.SDN_PROVIDER, (Object)this);
        String weaveVersion = (String)this.config().get(WEAVE_VERSION);
        if (Strings.isNonBlank((CharSequence)weaveVersion)) {
            agentSpec.configure(SoftwareProcess.SUGGESTED_VERSION, (Object)weaveVersion);
        }
        this.sensors().set((AttributeSensor)SDN_AGENT_SPEC, (Object)agentSpec);
        Cidr weaveCidr = this.getNextSubnetCidr();
        this.config().set(AGENT_CIDR, (Object)weaveCidr);
    }

    public String getIconUrl() {
        return "classpath://weaveworks-logo.png";
    }

    @Override
    public Collection<IpPermission> getIpPermissions(String source) {
        MutableList permissions = MutableList.of();
        Integer weavePort = (Integer)this.config().get(WeaveRouter.WEAVE_PORT);
        IpPermission weaveTcpPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(weavePort.intValue()).toPort(weavePort.intValue()).cidrBlock(Cidr.UNIVERSAL.toString()).build();
        permissions.add(weaveTcpPort);
        IpPermission weaveUdpPort = IpPermission.builder().ipProtocol(IpProtocol.UDP).fromPort(weavePort.intValue()).toPort(weavePort.intValue()).cidrBlock(Cidr.UNIVERSAL.toString()).build();
        permissions.add(weaveUdpPort);
        return permissions;
    }

    @Override
    public void addHost(DockerHost host) {
        SshMachineLocation machine = ((DockerHostLocation)host.getDynamicLocation()).getMachine();
        EntitySpec spec = (EntitySpec)EntitySpec.create((EntitySpec)((EntitySpec)this.sensors().get((AttributeSensor)SDN_AGENT_SPEC))).configure((ConfigKey.HasConfigKey)WeaveRouter.DOCKER_HOST, (Object)host);
        WeaveRouter agent = (WeaveRouter)this.getAgents().addChild(spec);
        this.getAgents().addMember((Entity)agent);
        agent.start((Collection)ImmutableList.of((Object)machine));
        LOG.debug("{} added Weave service {}", (Object)this, (Object)agent);
    }

    @Override
    public void removeHost(DockerHost host) {
        SdnAgent agent = (SdnAgent)host.sensors().get(SdnAgent.SDN_AGENT);
        if (agent == null) {
            LOG.warn("{} cannot find Weave service: {}", (Object)this, (Object)host);
            return;
        }
        agent.stop();
        this.getAgents().removeMember((Entity)agent);
        Entities.unmanage((Entity)agent);
        LOG.debug("{} removed Weave service {}", (Object)this, (Object)agent);
    }
}

