/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.location.DockerLocation;
import clocker.docker.networking.entity.VirtualNetwork;
import clocker.docker.networking.entity.sdn.DockerSdnProvider;
import clocker.docker.networking.entity.sdn.SdnAgent;
import clocker.docker.networking.entity.sdn.SdnProvider;
import clocker.docker.networking.location.NetworkProvisioningExtension;
import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.group.BasicGroup;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.stock.BasicStartableImpl;
import org.apache.brooklyn.entity.stock.DelegateEntity;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.net.Cidr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SdnProviderImpl
extends BasicStartableImpl
implements DockerSdnProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SdnProvider.class);
    protected final transient Object addressMutex = new Object[0];
    protected final transient Object hostMutex = new Object[0];
    protected final transient Object networkMutex = new Object[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        LOG.info("Starting SDN provider id {}", (Object)this.getId());
        super.init();
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_INFRASTRUCTURE);
        BasicGroup agents = (BasicGroup)this.addChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(BasicGroup.class).configure(BasicGroup.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty())).configure(BasicGroup.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty())).displayName("SDN Host Agents"));
        BasicGroup networks = (BasicGroup)this.addChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(BasicGroup.class).configure(BasicGroup.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty())).configure(BasicGroup.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty())).displayName("SDN Managed Networks"));
        this.sensors().set(SDN_AGENTS, (Object)agents);
        this.sensors().set(SDN_NETWORKS, (Object)networks);
        Object object = this.addressMutex;
        synchronized (object) {
            this.sensors().set(ALLOCATED_IPS, (Object)0);
            this.sensors().set(ALLOCATED_ADDRESSES, (Object)Maps.newConcurrentMap());
            this.sensors().set(SUBNET_ADDRESS_ALLOCATIONS, (Object)Maps.newConcurrentMap());
        }
        object = this.networkMutex;
        synchronized (object) {
            this.sensors().set(ALLOCATED_NETWORKS, (Object)0);
            this.sensors().set(SUBNETS, (Object)Maps.newConcurrentMap());
        }
        this.sensors().set(SUBNET_ENTITIES, (Object)Maps.newConcurrentMap());
        this.sensors().set(CONTAINER_ADDRESSES, (Object)HashMultimap.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getNextAgentAddress(String agentId) {
        Object object = this.addressMutex;
        synchronized (object) {
            Cidr cidr = (Cidr)this.config().get(AGENT_CIDR);
            Integer allocated = (Integer)this.sensors().get(ALLOCATED_IPS);
            InetAddress next = cidr.addressAtOffset(allocated + 1);
            this.sensors().set(ALLOCATED_IPS, (Object)(allocated + 1));
            Map addresses = (Map)this.sensors().get(ALLOCATED_ADDRESSES);
            addresses.put(agentId, next);
            this.sensors().set(ALLOCATED_ADDRESSES, (Object)addresses);
            return next;
        }
    }

    @Override
    public InetAddress getNextContainerAddress(String subnetId) {
        Cidr cidr = this.getSubnetCidr(subnetId);
        Object object = this.addressMutex;
        synchronized (object) {
            Map allocations = (Map)this.sensors().get(SUBNET_ADDRESS_ALLOCATIONS);
            List allocated = (List)allocations.get(subnetId);
            if (allocated == null) {
                allocated = MutableList.of();
            }
            int size = 1 << 32 - cidr.getLength();
            int next = allocated.size();
            do {
                InetAddress addr;
                if (allocated.contains(addr = cidr.addressAtOffset(next + 1))) continue;
                allocated.add(addr);
                allocations.put(subnetId, allocated);
                this.sensors().set(SUBNET_ADDRESS_ALLOCATIONS, (Object)allocations);
                return addr;
            } while (++next < size);
            throw new IllegalStateException("No more addresses in subnet: " + subnetId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordContainerAddress(String subnetId, InetAddress address) {
        Object object = this.addressMutex;
        synchronized (object) {
            Map allocations = (Map)this.sensors().get(SUBNET_ADDRESS_ALLOCATIONS);
            List allocated = (List)allocations.get(subnetId);
            if (allocated == null) {
                allocated = MutableList.of();
            }
            allocated.add(address);
            allocations.put(subnetId, allocated);
            this.sensors().set(SUBNET_ADDRESS_ALLOCATIONS, (Object)allocations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associateContainerAddress(String containerId, InetAddress address) {
        Object object = this.addressMutex;
        synchronized (object) {
            Multimap allocations = (Multimap)this.sensors().get(CONTAINER_ADDRESSES);
            allocations.put((Object)containerId, (Object)address);
            this.sensors().set(CONTAINER_ADDRESSES, (Object)allocations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cidr getNextSubnetCidr(String networkId) {
        Object object = this.networkMutex;
        synchronized (object) {
            Cidr networkCidr = this.getNextSubnetCidr();
            this.recordSubnetCidr(networkId, networkCidr);
            return networkCidr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cidr getNextSubnetCidr() {
        Object object = this.networkMutex;
        synchronized (object) {
            Cidr networkCidr = (Cidr)this.config().get(CONTAINER_NETWORK_CIDR);
            Integer networkSize = (Integer)this.config().get(CONTAINER_NETWORK_SIZE);
            Integer allocated = (Integer)this.sensors().get(ALLOCATED_NETWORKS);
            InetAddress baseAddress = networkCidr.addressAtOffset(allocated * (1 << 32 - networkSize));
            Cidr subnetCidr = new Cidr(baseAddress.getHostAddress() + "/" + networkSize);
            LOG.debug("Allocated {} from {} for subnet #{}", new Object[]{subnetCidr, networkCidr, allocated});
            this.sensors().set(ALLOCATED_NETWORKS, (Object)(allocated + 1));
            return subnetCidr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordSubnetCidr(String networkId, Cidr subnetCidr) {
        Object object = this.networkMutex;
        synchronized (object) {
            Map subnets = (Map)this.sensors().get(SdnProvider.SUBNETS);
            subnets.put(networkId, subnetCidr);
            this.sensors().set(SdnProvider.SUBNETS, (Object)subnets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cidr getSubnetCidr(String networkId) {
        Object object = this.networkMutex;
        synchronized (object) {
            Map subnets = (Map)this.sensors().get(SdnProvider.SUBNETS);
            return (Cidr)subnets.get(networkId);
        }
    }

    @Override
    public Object getNetworkMutex() {
        return this.networkMutex;
    }

    @Override
    public DynamicCluster getDockerHostCluster() {
        return (DynamicCluster)((Entity)this.config().get((ConfigKey.HasConfigKey)DOCKER_INFRASTRUCTURE)).sensors().get(DockerInfrastructure.DOCKER_HOST_CLUSTER);
    }

    @Override
    public Group getAgents() {
        return (Group)this.sensors().get(SDN_AGENTS);
    }

    public void start(Collection<? extends Location> locs) {
        this.addLocations(locs);
        MutableList locations = MutableList.copyOf((Iterable)Locations.getLocationsCheckingAncestors(locs, (Entity)this));
        this.sensors().set(SERVICE_UP, (Object)Boolean.FALSE);
        DockerInfrastructure infrastructure = (DockerInfrastructure)this.config().get((ConfigKey.HasConfigKey)DOCKER_INFRASTRUCTURE);
        ((DockerLocation)infrastructure.getDynamicLocation()).addExtension(NetworkProvisioningExtension.class, this);
        super.start((Collection)locations);
        this.addHostTrackerPolicy();
        this.sensors().set(SERVICE_UP, (Object)Boolean.TRUE);
    }

    public void stop() {
        this.sensors().set(SERVICE_UP, (Object)Boolean.FALSE);
        super.stop();
    }

    public void rebind() {
        super.rebind();
    }

    protected void addHostTrackerPolicy() {
        DynamicCluster hosts = this.getDockerHostCluster();
        if (hosts != null) {
            MemberTrackingPolicy hostTrackerPolicy = (MemberTrackingPolicy)this.policies().add((PolicySpec)((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Docker host tracker")).configure((CharSequence)"group", (Object)hosts));
            LOG.info("Added policy {} to {}, during start", (Object)hostTrackerPolicy, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHostAdded(Entity item) {
        Object object = this.hostMutex;
        synchronized (object) {
            if (item instanceof DockerHost) {
                this.addHost((DockerHost)item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHostRemoved(Entity item) {
        Object object = this.hostMutex;
        synchronized (object) {
            if (item instanceof DockerHost) {
                this.removeHost((DockerHost)item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHostChanged(Entity item) {
        Object object = this.hostMutex;
        synchronized (object) {
            boolean exists = this.getDockerHostCluster().hasMember(item);
            Boolean running = (Boolean)item.sensors().get(SERVICE_UP);
            if (exists && running.booleanValue() && item.sensors().get(SdnAgent.SDN_AGENT) == null) {
                this.onHostAdded(item);
            } else if (!exists) {
                this.onHostRemoved(item);
            }
        }
    }

    protected abstract void addHost(DockerHost var1);

    protected abstract void removeHost(DockerHost var1);

    @Override
    public Map<String, Cidr> listManagedNetworkAddressSpace() {
        return ImmutableMap.copyOf((Map)((Map)this.sensors().get(SUBNETS)));
    }

    @Override
    public void provisionNetwork(VirtualNetwork network) {
        SdnAgent agent = (SdnAgent)this.getAgents().getMembers().iterator().next();
        String networkId = agent.provisionNetwork(network);
        LOG.info("Provisioned network {} at {}", (Object)networkId, (Object)agent);
        ((Group)this.sensors().get(SDN_NETWORKS)).addMember((Entity)network);
    }

    @Override
    public void deallocateNetwork(VirtualNetwork network) {
        String networkId = (String)network.sensors().get(VirtualNetwork.NETWORK_ID);
        ((Group)this.sensors().get(SDN_NETWORKS)).removeMember((Entity)network);
        SdnAgent agent = (SdnAgent)this.getAgents().getMembers().iterator().next();
        agent.deallocateNetwork(network);
        LOG.info("Deallocated network {} at {}", (Object)networkId, (Object)agent);
    }

    static {
        RendererHints.register((AttributeSensor)SDN_AGENTS, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)SDN_NETWORKS, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)DOCKER_INFRASTRUCTURE, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity member) {
            ((SdnProviderImpl)this.entity).onHostChanged(member);
        }
    }
}

