/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.location.jclouds.BasicJcloudsLocationCustomizer;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsHostnameCustomizer
extends BasicJcloudsLocationCustomizer {
    public static final Logger LOG = LoggerFactory.getLogger(JcloudsHostnameCustomizer.class);

    public static JcloudsHostnameCustomizer instanceOf() {
        return new JcloudsHostnameCustomizer();
    }

    public void customize(JcloudsLocation location, ComputeService computeService, JcloudsMachineLocation machine) {
        JcloudsSshMachineLocation ssh = (JcloudsSshMachineLocation)machine;
        String name = ((NodeMetadata)ssh.getOptionalNode().get()).getName();
        ImmutableList commands = ImmutableList.of((Object)String.format("echo %s | ( %s )", name, BashCommands.sudo((String)"tee /etc/hostname")), (Object)String.format("echo 127.0.0.1 localhost | ( %s )", BashCommands.sudo((String)"tee /etc/hosts")));
        ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((List)commands).machine((SshMachineLocation)ssh)).requiringExitCodeZero())).block();
        LOG.debug("Set {} hostname to {}", new Object[]{ssh, name});
    }
}

