/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.test;

import clocker.docker.entity.DockerHost;
import clocker.docker.location.DockerHostLocation;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.factory.ApplicationBuilder;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.util.collections.MutableMap;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"Live"})
public class DockerOnDockerLiveTest {
    private static final String PROVIDER = "docker-boot2docker";
    protected BrooklynProperties brooklynProperties;
    protected ManagementContext ctx;
    protected TestApplication app;
    protected Location jcloudsLocation;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        ImmutableList propsToRemove = ImmutableList.of((Object)"imageDescriptionRegex", (Object)"imageNameRegex", (Object)"inboundPorts", (Object)"hardwareId", (Object)"minRam");
        this.brooklynProperties = BrooklynProperties.Factory.newDefault();
        for (String propToRemove : propsToRemove) {
            for (String propVariant : ImmutableList.of((Object)propToRemove, (Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, propToRemove))) {
                this.brooklynProperties.remove((Object)("brooklyn.locations.jclouds.docker-boot2docker." + propVariant));
                this.brooklynProperties.remove((Object)("brooklyn.locations." + propVariant));
                this.brooklynProperties.remove((Object)("brooklyn.jclouds.docker-boot2docker." + propVariant));
                this.brooklynProperties.remove((Object)("brooklyn.jclouds." + propVariant));
            }
        }
        this.brooklynProperties.remove((Object)"brooklyn.ssh.config.scriptHeader");
        this.ctx = new LocalManagementContext(this.brooklynProperties);
        this.app = (TestApplication)ApplicationBuilder.newManagedApp(TestApplication.class, (ManagementContext)this.ctx);
    }

    protected void runTest(Map<String, ?> flags) throws Exception {
        String tag = this.getClass().getSimpleName().toLowerCase();
        MutableMap allFlags = MutableMap.builder().put((Object)"tags", (Object)ImmutableList.of((Object)tag)).putAll(flags).build();
        this.jcloudsLocation = this.ctx.getLocationRegistry().resolve(PROVIDER, (Map)allFlags);
        DockerHost dockerHost = (DockerHost)this.app.createAndManageChild((EntitySpec)EntitySpec.create(DockerHost.class).configure((CharSequence)"docker.port", (Object)"4244+"));
        this.app.start((Collection)ImmutableList.of((Object)this.jcloudsLocation));
        DockerHostLocation location = (DockerHostLocation)dockerHost.createLocation((Map)Maps.newHashMap());
        this.app.start((Collection)ImmutableList.of((Object)location));
    }

    @Test(groups={"Live", "WIP"})
    public void test_Ubuntu_12_04() throws Exception {
        this.runTest((Map<String, ?>)ImmutableMap.of((Object)"imageId", (Object)"269778b3ca2a6a21cff07aca8b2ac05abaa8b5ddbe6f10b715af2fdd81af657a", (Object)"loginUser", (Object)"root", (Object)"loginUser.password", (Object)"password"));
    }
}

