/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.test;

import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.location.DockerLocation;
import clocker.docker.test.AbstractClockerIntegrationTest;
import clocker.docker.test.DockerInfrastructureTests;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DockerInfrastructureLiveTest
extends AbstractClockerIntegrationTest {
    @Test(groups={"Live"})
    public void testRegistersLocation() throws Exception {
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(DockerInfrastructure.class).configure(DockerInfrastructure.DOCKER_HOST_CLUSTER_MIN_SIZE, (Object)1)).configure(DockerInfrastructure.LOCATION_NAME_PREFIX, (Object)"dynamicdockertest")).configure(DockerInfrastructure.SDN_ENABLE, (Object)false)).displayName("Docker Infrastructure"));
        this.app.start((Collection)ImmutableList.of((Object)this.testLocation));
        LocationDefinition infraLocDef = this.findLocationMatchingName("dynamicdockertest.*");
        Location infraLoc = this.mgmt.getLocationRegistry().resolve(infraLocDef);
        Assert.assertTrue((boolean)(infraLoc instanceof DockerLocation), (String)("loc=" + infraLoc));
    }

    @Test(groups={"Live"})
    public void testDeploysTrivialApplication() throws Exception {
        DockerInfrastructureTests.testDeploysTrivialApplication(this.app, this.testLocation);
    }

    private LocationDefinition findLocationMatchingName(String regex) {
        ArrayList contenders = Lists.newArrayList();
        for (Map.Entry entry : this.mgmt.getLocationRegistry().getDefinedLocations().entrySet()) {
            String name = ((LocationDefinition)entry.getValue()).getName();
            if (name.matches(regex)) {
                return (LocationDefinition)entry.getValue();
            }
            contenders.add(name);
        }
        throw new NoSuchElementException("No location matching regex: " + regex + "; contenders were " + contenders);
    }
}

