/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.storage.softlayer;

import brooklyn.location.jclouds.BasicJcloudsLocationCustomizer;
import brooklyn.location.jclouds.JcloudsLocationCustomizer;
import brooklyn.location.jclouds.JcloudsSshMachineLocation;
import java.util.Arrays;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;

public class SoftlayerVolumeCustomizer {
    public static JcloudsLocationCustomizer withNewVolume(final String ec2DeviceName, final String osDeviceName, final String mountPoint, final String filesystemType, final String availabilityZone, final int sizeInGib, final boolean deleteOnTermination) {
        return new BasicJcloudsLocationCustomizer(){

            public void customize(ComputeService computeService, TemplateBuilder templateBuilder) {
                templateBuilder.locationId(availabilityZone);
            }

            public void customize(ComputeService computeService, TemplateOptions templateOptions) {
                ((EC2TemplateOptions)templateOptions).mapNewVolumeToDeviceName(ec2DeviceName, sizeInGib, deleteOnTermination);
            }

            public void customize(ComputeService computeService, JcloudsSshMachineLocation machine) {
                SoftlayerVolumeCustomizer.createFilesystem(machine, osDeviceName, filesystemType);
                SoftlayerVolumeCustomizer.mountFilesystem(machine, osDeviceName, mountPoint);
            }
        };
    }

    public static JcloudsLocationCustomizer withExistingSnapshot(final String ec2DeviceName, final String osDeviceName, final String mountPoint, final String availabilityZone, final String snapshotId, final int sizeInGib, final boolean deleteOnTermination) {
        return new BasicJcloudsLocationCustomizer(){

            public void customize(ComputeService computeService, TemplateBuilder templateBuilder) {
                templateBuilder.locationId(availabilityZone);
            }

            public void customize(ComputeService computeService, TemplateOptions templateOptions) {
                ((EC2TemplateOptions)templateOptions).mapEBSSnapshotToDeviceName(ec2DeviceName, snapshotId, Integer.valueOf(sizeInGib), deleteOnTermination);
            }

            public void customize(ComputeService computeService, JcloudsSshMachineLocation machine) {
                SoftlayerVolumeCustomizer.mountFilesystem(machine, osDeviceName, mountPoint);
            }
        };
    }

    private static void createFilesystem(JcloudsSshMachineLocation machine, String osDeviceName, String filesystemType) {
        machine.execCommands("Creating filesystem on EBS volume", Arrays.asList("mkfs." + filesystemType + " " + osDeviceName));
    }

    private static void mountFilesystem(JcloudsSshMachineLocation machine, String osDeviceName, String mountPoint) {
        machine.execCommands("Mounting EBS volume", Arrays.asList("mkdir -m 000 " + mountPoint, "echo \"" + osDeviceName + " " + mountPoint + " auto noatime 0 0\" | sudo tee -a /etc/fstab", "mount " + mountPoint));
    }
}

