/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn.weave;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.networking.sdn.SdnProviderImpl;
import brooklyn.networking.sdn.weave.WeaveContainer;
import brooklyn.networking.sdn.weave.WeaveNetwork;
import brooklyn.util.collections.MutableList;
import brooklyn.util.net.Cidr;
import brooklyn.util.text.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeaveNetworkImpl
extends SdnProviderImpl
implements WeaveNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(WeaveNetwork.class);

    @Override
    public void init() {
        LOG.info("Starting Weave network id {}", (Object)this.getId());
        super.init();
        EntitySpec agentSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.getConfig((ConfigKey.HasConfigKey)SdnProvider.SDN_AGENT_SPEC, EntitySpec.create(WeaveContainer.class)))).configure(WeaveContainer.WEAVE_PORT, this.config().get(WeaveNetwork.WEAVE_PORT)).configure((ConfigKey.HasConfigKey)WeaveContainer.SDN_PROVIDER, (Object)this);
        String weaveVersion = (String)this.config().get(WEAVE_VERSION);
        if (Strings.isNonBlank((CharSequence)weaveVersion)) {
            agentSpec.configure(SoftwareProcess.SUGGESTED_VERSION, (Object)weaveVersion);
        }
        this.setAttribute((AttributeSensor)SdnProvider.SDN_AGENT_SPEC, agentSpec);
        Cidr weaveCidr = this.getNextSubnetCidr();
        this.config().set(AGENT_CIDR, (Object)weaveCidr);
    }

    @Override
    public Collection<IpPermission> getIpPermissions(String source) {
        MutableList permissions = MutableList.of();
        Integer weavePort = (Integer)this.config().get(WeaveContainer.WEAVE_PORT);
        IpPermission weaveTcpPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(weavePort.intValue()).toPort(weavePort.intValue()).cidrBlock(Cidr.UNIVERSAL.toString()).build();
        permissions.add(weaveTcpPort);
        IpPermission weaveUdpPort = IpPermission.builder().ipProtocol(IpProtocol.UDP).fromPort(weavePort.intValue()).toPort(weavePort.intValue()).cidrBlock(Cidr.UNIVERSAL.toString()).build();
        permissions.add(weaveUdpPort);
        return permissions;
    }

    @Override
    public void addHost(DockerHost host) {
        SshMachineLocation machine = ((DockerHostLocation)host.getDynamicLocation()).getMachine();
        EntitySpec spec = EntitySpec.create((EntitySpec)((EntitySpec)this.getAttribute((AttributeSensor)SDN_AGENT_SPEC))).configure((ConfigKey.HasConfigKey)WeaveContainer.DOCKER_HOST, (Object)host);
        WeaveContainer agent = (WeaveContainer)this.getAgents().addChild(spec);
        Entities.manage((Entity)agent);
        this.getAgents().addMember((Entity)agent);
        agent.start((Collection)ImmutableList.of((Object)machine));
        LOG.debug("{} added Weave service {}", (Object)this, (Object)agent);
    }

    @Override
    public void removeHost(DockerHost host) {
        SdnAgent agent = (SdnAgent)host.getAttribute(SdnAgent.SDN_AGENT);
        if (agent == null) {
            LOG.warn("{} cannot find Weave service: {}", (Object)this, (Object)host);
            return;
        }
        agent.stop();
        this.getAgents().removeMember((Entity)agent);
        Entities.unmanage((Entity)agent);
        LOG.debug("{} removed Weave service {}", (Object)this, (Object)agent);
    }
}

