/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn.calico;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractGroup;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.nosql.etcd.EtcdNode;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.networking.sdn.calico.CalicoNode;
import brooklyn.networking.sdn.calico.CalicoNodeDriver;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Cidr;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.text.Strings;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalicoNodeSshDriver
extends AbstractSoftwareProcessSshDriver
implements CalicoNodeDriver {
    private static final Logger LOG = LoggerFactory.getLogger(CalicoNode.class);

    public CalicoNodeSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    public void postLaunch() {
    }

    public String getCalicoCommand() {
        return Os.mergePathsUnix((String[])new String[]{this.getInstallDir(), "calicoctl"});
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
    }

    public void install() {
        LinkedList commands = Lists.newLinkedList();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)this.resolver.getTargets(), (String)this.getCalicoCommand()));
        commands.add("chmod 755 " + this.getCalicoCommand());
        commands.add(BashCommands.installPackage((String)"ipset"));
        commands.add(BashCommands.sudo((String)"modprobe ip6_tables"));
        commands.add(BashCommands.sudo((String)"modprobe xt_set"));
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        this.newScript("customizing").execute();
    }

    public void launch() {
        InetAddress address = (InetAddress)this.getEntity().getAttribute(SdnAgent.SDN_AGENT_ADDRESS);
        Boolean firstMember = (Boolean)this.getEntity().getAttribute(AbstractGroup.FIRST_MEMBER);
        LOG.info("Launching {} calico service at {}", (Object)(Boolean.TRUE.equals(firstMember) ? "first" : "next"), (Object)address.getHostAddress());
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)BashCommands.sudo((String)String.format("%s node --ip=%s", this.getCalicoCommand(), address.getHostAddress()))).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)BashCommands.sudo((String)String.format("%s status", this.getCalicoCommand()))).execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)BashCommands.sudo((String)(this.getCalicoCommand() + " node stop --force"))).execute();
    }

    @Override
    public void createSubnet(String virtualNetworkId, String subnetId, Cidr subnetCidr) {
        this.newScript((String)"createSubnet").body.append((CharSequence)BashCommands.sudo((String)String.format("%s ipv4 pool add %s", this.getCalicoCommand(), subnetCidr))).execute();
    }

    @Override
    public InetAddress attachNetwork(String containerId, String subnetId) {
        InetAddress address = ((SdnProvider)this.getEntity().getAttribute(SdnAgent.SDN_PROVIDER)).getNextContainerAddress(subnetId);
        String ipAddrOutput = ((DockerHost)this.getEntity().getAttribute(SdnAgent.DOCKER_HOST)).execCommand(BashCommands.sudo((String)"ip addr show dev docker0 scope global label docker0"));
        String dockerIp = Strings.getFirstWordAfter((String)ipAddrOutput.replace('/', ' '), (String)"inet");
        String dockerPid = Strings.trimEnd((String)((DockerHost)this.getEntity().getAttribute(SdnAgent.DOCKER_HOST)).runDockerCommand("inspect -f '{{.State.Pid}}' " + containerId));
        Cidr subnetCidr = ((SdnProvider)this.getEntity().getAttribute(SdnAgent.SDN_PROVIDER)).getSubnetCidr(subnetId);
        InetAddress agentAddress = (InetAddress)this.getEntity().getAttribute(SdnAgent.SDN_AGENT_ADDRESS);
        boolean initial = false;
        for (Entity container : ((DockerHost)this.getEntity().getAttribute(SdnAgent.DOCKER_HOST)).getDockerContainerList()) {
            if (!containerId.equals(container.getAttribute(DockerContainer.CONTAINER_ID))) continue;
            Entity running = (Entity)container.getAttribute(DockerContainer.ENTITY);
            String applicationId = running.getApplicationId();
            if (!subnetId.equals(applicationId)) break;
            initial = true;
            break;
        }
        MutableList commands = MutableList.of();
        if (initial) {
            commands.add(BashCommands.sudo((String)String.format("%s container add %s %s", this.getCalicoCommand(), containerId, address.getHostAddress())));
            commands.add(BashCommands.sudo((String)String.format("%s profile add %s", this.getCalicoCommand(), subnetId)));
            commands.add(BashCommands.sudo((String)String.format("%s profile %s member add %s", this.getCalicoCommand(), subnetId, containerId)));
            commands.add(BashCommands.sudo((String)String.format("ip netns exec %s ip route del default", dockerPid)));
            commands.add(BashCommands.sudo((String)String.format("ip netns exec %s ip route add default via %s", dockerPid, dockerIp)));
            commands.add(BashCommands.sudo((String)String.format("ip netns exec %s ip route add %s via %s", dockerPid, subnetCidr.toString(), agentAddress.getHostAddress())));
        } else {
            commands.add(BashCommands.sudo((String)String.format("ip netns exec %s ip addr add %s/%d dev eth1", dockerPid, address.getHostAddress(), subnetCidr.getLength())));
        }
        this.newScript((String)"attachNetwork").body.append((Collection)commands).execute();
        return address;
    }

    public Map<String, String> getShellEnvironment() {
        Entity etcdNode = (Entity)this.getEntity().config().get(CalicoNode.ETCD_NODE);
        HostAndPort etcdAuthority = HostAndPort.fromParts((String)((String)etcdNode.getAttribute(Attributes.SUBNET_ADDRESS)), (int)((Integer)etcdNode.getAttribute((AttributeSensor)EtcdNode.ETCD_CLIENT_PORT)));
        MutableMap environment = MutableMap.copyOf((Map)super.getShellEnvironment());
        environment.put("ETCD_AUTHORITY", etcdAuthority.toString());
        return environment;
    }
}

