/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn.calico;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.nosql.etcd.EtcdCluster;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.networking.sdn.calico.CalicoNetworkImpl;
import brooklyn.util.flags.SetFromFlag;

@Catalog(name="Calico Infrastructure", description="Calico SDN", iconUrl="classpath://calico-logo.png")
@ImplementedBy(value=CalicoNetworkImpl.class)
public interface CalicoNetwork
extends SdnProvider {
    @SetFromFlag(value="calicoVersion")
    public static final ConfigKey<String> CALICO_VERSION = ConfigKeys.newStringConfigKey((String)"calico.version", (String)"The Calico SDN version number", (String)"0.4.2");
    @SetFromFlag(value="etcdVersion")
    public static final ConfigKey<String> ETCD_VERSION = ConfigKeys.newStringConfigKey((String)"etcd.version", (String)"The Etcd version number", (String)"2.0.11");
    public static final ConfigKey<Boolean> EXTERNAL_ETCD_CLUSTER = ConfigKeys.newBooleanConfigKey((String)"calico.etcd.external", (String)"Whether to use an external Etcd cluster", (Boolean)Boolean.FALSE);
    public static final ConfigKey<Integer> EXTERNAL_ETCD_INITIAL_SIZE = ConfigKeys.newIntegerConfigKey((String)"calico.etcd.external.initialSize", (String)"The initial size of the external Etcd cluster");
    public static final AttributeSensorAndConfigKey<String, String> EXTERNAL_ETCD_URL = ConfigKeys.newStringSensorAndConfigKey((String)"calico.etcd.external.url", (String)"The URL for the external Etcd cluster (if configured, no cluster will be provisioned)");
    public static final AttributeSensor<EtcdCluster> ETCD_CLUSTER = Sensors.newSensor(EtcdCluster.class, (String)"etcd.cluster", (String)"The EtcdCluster entity for storing state");
}

