/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.BasicStartable;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.container.DockerAttributes;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.networking.VirtualNetwork;
import brooklyn.networking.location.NetworkProvisioningExtension;
import brooklyn.networking.sdn.SdnProviderImpl;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.net.Cidr;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import com.google.inject.ImplementedBy;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import org.jclouds.net.domain.IpPermission;

@ImplementedBy(value=SdnProviderImpl.class)
public interface SdnProvider
extends BasicStartable,
NetworkProvisioningExtension {
    public static final ConfigKey<Cidr> AGENT_CIDR = ConfigKeys.newConfigKey(Cidr.class, (String)"sdn.agent.cidr", (String)"CIDR for agent address allocation");
    public static final AttributeSensor<Cidr> APPLICATION_CIDR = Sensors.newSensor(Cidr.class, (String)"sdn.application.cidr", (String)"CIDR for application running in container");
    public static final ConfigKey<Cidr> CONTAINER_NETWORK_CIDR = ConfigKeys.newConfigKey(Cidr.class, (String)"sdn.network.cidr", (String)"Pool CIDR for network allocation to containers", (Object)Cidr.LINK_LOCAL);
    public static final ConfigKey<Integer> CONTAINER_NETWORK_SIZE = ConfigKeys.newIntegerConfigKey((String)"sdn.network.size", (String)"Size of network subnets as CIDR length (e.g. 24 for 254 hosts)", (Integer)24);
    public static final AttributeSensor<Integer> ALLOCATED_NETWORKS = Sensors.newIntegerSensor((String)"sdn.networks.allocated", (String)"Number of allocated networks");
    public static final AttributeSensor<Map<String, Cidr>> SUBNETS = Sensors.newSensor((TypeToken)new TypeToken<Map<String, Cidr>>(){}, (String)"sdn.networks.addresses", (String)"Map of network subnets that have been created");
    public static final AttributeSensor<Map<String, VirtualNetwork>> SUBNET_ENTITIES = Sensors.newSensor((TypeToken)new TypeToken<Map<String, VirtualNetwork>>(){}, (String)"sdn.networks.entities", (String)"Map of managed network entities that have been created by this SDN");
    public static final AttributeSensor<Map<String, Integer>> SUBNET_ADDRESS_ALLOCATIONS = Sensors.newSensor((TypeToken)new TypeToken<Map<String, Integer>>(){}, (String)"sdn.networks.addresses.allocated", (String)"Map of allocated address count on network subnets");
    public static final AttributeSensor<Multimap<String, InetAddress>> CONTAINER_ADDRESSES = Sensors.newSensor((TypeToken)new TypeToken<Multimap<String, InetAddress>>(){}, (String)"sdn.container.addresses", (String)"Map of container ID to IP addresses on network");
    public static final AttributeSensor<Group> SDN_AGENTS = Sensors.newSensor(Group.class, (String)"sdn.agents", (String)"Group of SDN agent services");
    public static final AttributeSensor<Integer> ALLOCATED_IPS = Sensors.newIntegerSensor((String)"sdn.agent.ips", (String)"Number of allocated IPs for agents");
    public static final AttributeSensor<Map<String, InetAddress>> ALLOCATED_ADDRESSES = Sensors.newSensor((TypeToken)new TypeToken<Map<String, InetAddress>>(){}, (String)"sdn.agent.addresses", (String)"Allocated IP addresses for agents");
    @SetFromFlag(value="agentSpec")
    public static final AttributeSensorAndConfigKey<EntitySpec<?>, EntitySpec<?>> SDN_AGENT_SPEC = ConfigKeys.newSensorAndConfigKey((TypeToken)new TypeToken<EntitySpec<?>>(){}, (String)"sdn.agent.spec", (String)"SDN agent specification");
    @SetFromFlag(value="dockerInfrastructure")
    public static final AttributeSensorAndConfigKey<Entity, Entity> DOCKER_INFRASTRUCTURE = DockerAttributes.DOCKER_INFRASTRUCTURE;
    public static final AttributeSensor<Group> SDN_NETWORKS = Sensors.newSensor(Group.class, (String)"sdn.networks.managed", (String)"Collection of virtual network entites managed by this SDN");
    public static final AttributeSensor<Group> SDN_APPLICATIONS = Sensors.newSensor(Group.class, (String)"sdn.networks.applications", (String)"Groupings of application containers attached to each managed network");

    public Collection<IpPermission> getIpPermissions(String var1);

    public DynamicCluster getDockerHostCluster();

    public Group getAgents();

    public InetAddress getNextContainerAddress(String var1);

    public InetAddress getNextAgentAddress(String var1);

    public Cidr getNextSubnetCidr(String var1);

    public Cidr getNextSubnetCidr();

    public void recordSubnetCidr(String var1, Cidr var2);

    public void recordSubnetCidr(String var1, Cidr var2, int var3);

    public Cidr getSubnetCidr(String var1);

    public void addHost(DockerHost var1);

    public void removeHost(DockerHost var1);

    public Object getNetworkMutex();
}

