/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn;

import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.DynamicGroup;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.networking.VirtualNetwork;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.SdnAgentDriver;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.util.net.Cidr;
import brooklyn.util.repeat.Repeater;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.time.Duration;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SdnAgentImpl
extends SoftwareProcessImpl
implements SdnAgent {
    private static final Logger LOG = LoggerFactory.getLogger(SdnAgent.class);

    public void init() {
        super.init();
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_HOST);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)SDN_PROVIDER);
    }

    public SdnAgentDriver getDriver() {
        return (SdnAgentDriver)super.getDriver();
    }

    protected void connectSensors() {
        super.connectSensors();
        super.connectServiceUpIsRunning();
    }

    public void disconnectSensors() {
        super.disconnectServiceUpIsRunning();
        super.disconnectSensors();
    }

    @Override
    public DockerHost getDockerHost() {
        return (DockerHost)this.getAttribute((AttributeSensor)DOCKER_HOST);
    }

    public void preStart() {
        InetAddress address = ((SdnProvider)this.getAttribute((AttributeSensor)SDN_PROVIDER)).getNextAgentAddress(this.getId());
        this.setAttribute(SDN_AGENT_ADDRESS, address);
    }

    public void postStart() {
        ((EntityLocal)this.getDockerHost()).setAttribute(SDN_AGENT, (Object)this);
    }

    public void rebind() {
        super.rebind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress attachNetwork(String containerId, final String networkId) {
        VirtualNetwork network;
        final SdnProvider provider = (SdnProvider)this.getAttribute((AttributeSensor)SDN_PROVIDER);
        boolean createNetwork = false;
        Cidr subnetCidr = null;
        Object object = provider.getNetworkMutex();
        synchronized (object) {
            subnetCidr = provider.getSubnetCidr(networkId);
            if (subnetCidr == null) {
                subnetCidr = provider.getNextSubnetCidr(networkId);
                createNetwork = true;
            }
        }
        if (createNetwork) {
            EntitySpec networkSpec = EntitySpec.create(VirtualNetwork.class).configure(VirtualNetwork.NETWORK_ID, (Object)networkId).configure(VirtualNetwork.NETWORK_CIDR, (Object)subnetCidr);
            network = (VirtualNetwork)((Group)provider.getAttribute(SdnProvider.SDN_NETWORKS)).addChild(networkSpec);
            Entities.manage((Entity)network);
            Entities.start((Entity)network, Collections.singleton(((DockerInfrastructure)provider.getAttribute((AttributeSensor)SdnProvider.DOCKER_INFRASTRUCTURE)).getDynamicLocation()));
            Entities.waitForServiceUp((Entity)network);
        } else {
            Task lookup = TaskBuilder.builder().name("Waiting until virtual network is available").body((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Repeater.create().every(Duration.TEN_SECONDS).until((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            Optional found = Iterables.tryFind((Iterable)((Group)provider.getAttribute(SdnProvider.SDN_NETWORKS)).getMembers(), (Predicate)EntityPredicates.attributeEqualTo(VirtualNetwork.NETWORK_ID, (Object)networkId));
                            return found.isPresent();
                        }
                    }).limitTimeTo(Duration.ONE_MINUTE).run();
                }
            }).build();
            Boolean result = (Boolean)DynamicTasks.queueIfPossible((TaskAdaptable)lookup).orSubmitAndBlock().andWaitForSuccess();
            if (!result.booleanValue()) {
                throw new IllegalStateException(String.format("Cannot find virtual network entity for %s", networkId));
            }
        }
        InetAddress address = this.getDriver().attachNetwork(containerId, networkId);
        LOG.info("Attached container ID {} to {}: {}", new Object[]{containerId, networkId, address.getHostAddress()});
        network = (DynamicGroup)Iterables.find((Iterable)((Group)provider.getAttribute(SdnProvider.SDN_APPLICATIONS)).getMembers(), (Predicate)EntityPredicates.attributeEqualTo(VirtualNetwork.NETWORK_ID, (Object)networkId));
        network.rescanEntities();
        return address;
    }

    @Override
    public String provisionNetwork(VirtualNetwork network) {
        String networkId = (String)network.getAttribute((AttributeSensor)VirtualNetwork.NETWORK_ID);
        Cidr subnetCidr = (Cidr)network.config().get(VirtualNetwork.NETWORK_CIDR);
        if (subnetCidr == null) {
            subnetCidr = ((SdnProvider)this.getAttribute((AttributeSensor)SDN_PROVIDER)).getNextSubnetCidr(networkId);
        } else {
            ((SdnProvider)this.getAttribute((AttributeSensor)SDN_PROVIDER)).recordSubnetCidr(networkId, subnetCidr);
        }
        ((EntityLocal)network).setAttribute(VirtualNetwork.NETWORK_CIDR, (Object)subnetCidr);
        this.getDriver().createSubnet(network.getId(), networkId, subnetCidr);
        return networkId;
    }

    static {
        RendererHints.register((AttributeSensor)DOCKER_HOST, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)SDN_PROVIDER, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)SDN_AGENT, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
    }
}

