/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn;

import brooklyn.entity.annotation.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.networking.VirtualNetwork;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.util.flags.SetFromFlag;
import java.net.InetAddress;

public interface SdnAgent
extends SoftwareProcess {
    @SetFromFlag(value="host")
    public static final AttributeSensorAndConfigKey<DockerHost, DockerHost> DOCKER_HOST = ConfigKeys.newSensorAndConfigKey(DockerHost.class, (String)"sdn.agent.docker.host", (String)"Docker host we are running on");
    @SetFromFlag(value="provider")
    public static final AttributeSensorAndConfigKey<SdnProvider, SdnProvider> SDN_PROVIDER = ConfigKeys.newSensorAndConfigKey(SdnProvider.class, (String)"sdn.provider", (String)"SDN provider entity");
    public static final AttributeSensor<InetAddress> SDN_AGENT_ADDRESS = Sensors.newSensor(InetAddress.class, (String)"sdn.agent.address", (String)"IP address of SDN agent service");
    public static final AttributeSensor<SdnAgent> SDN_AGENT = Sensors.newSensor(SdnAgent.class, (String)"sdn.agent.entity", (String)"SDN agent entity");
    public static final MethodEffector<InetAddress> ATTACH_NETWORK = new MethodEffector(SdnAgent.class, "attachNetwork");

    public DockerHost getDockerHost();

    public String provisionNetwork(VirtualNetwork var1);

    @Effector(description="Attach a container to a network")
    public InetAddress attachNetwork(@EffectorParam(name="containerId", description="Container ID") String var1, @EffectorParam(name="networkId", description="Network ID") String var2);
}

