/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.basic.BasicStartableImpl;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.event.AttributeSensor;
import brooklyn.location.Location;
import brooklyn.networking.VirtualNetwork;
import brooklyn.networking.location.NetworkProvisioningExtension;
import brooklyn.util.net.Cidr;
import brooklyn.util.text.StringFunctions;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualNetworkImpl
extends BasicStartableImpl
implements VirtualNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualNetwork.class);

    public void init() {
        LOG.info("Starting virtual network segment id {}", (Object)this.getId());
        super.init();
        String networkId = (String)this.config().get((ConfigKey.HasConfigKey)NETWORK_ID);
        if (Strings.isEmpty((CharSequence)networkId)) {
            networkId = this.getId();
        }
        this.setAttribute((AttributeSensor)NETWORK_ID, networkId);
        this.setDisplayName(String.format("Virtual Network (%s)", networkId));
    }

    public void start(Collection<? extends Location> locations) {
        this.setAttribute(SERVICE_UP, Boolean.FALSE);
        super.start(locations);
        NetworkProvisioningExtension provisioner = this.findNetworkProvisioner(locations);
        this.setAttribute(NETWORK_PROVISIONER, provisioner);
        provisioner.provisionNetwork(this);
        this.setAttribute(SERVICE_UP, Boolean.TRUE);
    }

    public NetworkProvisioningExtension findNetworkProvisioner(Collection<? extends Location> locations) {
        Optional found = Iterables.tryFind(locations, (Predicate)new Predicate<Location>(){

            public boolean apply(Location input) {
                return input.hasExtension(NetworkProvisioningExtension.class);
            }
        });
        if (!found.isPresent()) {
            throw new IllegalStateException("Cannot start a virtual network in any location: " + Iterables.toString((Iterable)this.getLocations()));
        }
        NetworkProvisioningExtension provisioner = (NetworkProvisioningExtension)((Location)found.get()).getExtension(NetworkProvisioningExtension.class);
        return provisioner;
    }

    public void stop() {
        this.setAttribute(SERVICE_UP, Boolean.FALSE);
        NetworkProvisioningExtension provisioner = (NetworkProvisioningExtension)this.getAttribute(NETWORK_PROVISIONER);
        provisioner.deallocateNetwork(this);
        super.stop();
    }

    static {
        RendererHints.register(Cidr.class, (RendererHints.Hint)RendererHints.displayValue((Function)StringFunctions.toStringFunction()));
        RendererHints.register((AttributeSensor)NETWORKED_APPLICATIONS, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
    }
}

