/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Group;
import brooklyn.entity.basic.BasicStartable;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.networking.VirtualNetworkImpl;
import brooklyn.networking.location.NetworkProvisioningExtension;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.net.Cidr;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Map;

@ImplementedBy(value=VirtualNetworkImpl.class)
public interface VirtualNetwork
extends BasicStartable {
    @SetFromFlag(value="networkId")
    public static final AttributeSensorAndConfigKey<String, String> NETWORK_ID = ConfigKeys.newStringSensorAndConfigKey((String)"network.id", (String)"ID of the network segment");
    @SetFromFlag(value="cidr")
    public static final AttributeSensorAndConfigKey<Cidr, Cidr> NETWORK_CIDR = ConfigKeys.newSensorAndConfigKey(Cidr.class, (String)"network.cidr", (String)"CIDR for the network segment");
    @SetFromFlag(value="flags")
    public static final ConfigKey<Map<String, Object>> NETWORK_PROVISIONING_FLAGS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, Object>>(){}, (String)"network.flags", (String)"Extra configuration properties to set when provisioning the managed network segment", (Object)Maps.newHashMap());
    public static final AttributeSensor<Integer> ALLOCATED_ADDRESSES = Sensors.newIntegerSensor((String)"network.allocated", (String)"Allocated IP addresses");
    public static final AttributeSensor<NetworkProvisioningExtension> NETWORK_PROVISIONER = Sensors.newSensor(NetworkProvisioningExtension.class, (String)"network.provsioner", (String)"Location extension for provisioning networks");
    public static final AttributeSensor<Group> NETWORKED_APPLICATIONS = Sensors.newSensor(Group.class, (String)"network.aplications", (String)"Group containing entiities attached to the network");
}

