/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker.strategy;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.BasicGroup;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.strategy.BasicDockerPlacementStrategy;
import brooklyn.util.flags.SetFromFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxContainersPlacementStrategy
extends BasicDockerPlacementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MaxContainersPlacementStrategy.class);
    @SetFromFlag(value="maxContainers")
    public static final ConfigKey<Integer> DOCKER_CONTAINER_CLUSTER_MAX_SIZE = ConfigKeys.newIntegerConfigKey((String)"docker.container.cluster.maxSize", (String)"Maximum size of a Docker container cluster");
    public static final Integer DEFAULT_MAX_CONTAINERS = 8;

    @Override
    public boolean apply(DockerHostLocation input) {
        Integer currentSize;
        Integer infrastructureMax;
        Integer maxSize = (Integer)this.config().get(DOCKER_CONTAINER_CLUSTER_MAX_SIZE);
        DockerInfrastructure infrastructure = (DockerInfrastructure)this.config().get(DOCKER_INFRASTRUCTURE);
        if (infrastructure != null && (infrastructureMax = (Integer)infrastructure.config().get(DOCKER_CONTAINER_CLUSTER_MAX_SIZE)) != null) {
            maxSize = infrastructureMax;
        }
        if (maxSize == null) {
            maxSize = DEFAULT_MAX_CONTAINERS;
        }
        boolean accept = (currentSize = (Integer)((DynamicCluster)input.getOwner().getAttribute(DockerHost.DOCKER_CONTAINER_CLUSTER)).getAttribute(BasicGroup.GROUP_SIZE)) < maxSize;
        LOG.debug("Location {} size is {}/{}: {}", new Object[]{input, currentSize, maxSize, accept ? "accepted" : "rejected"});
        return accept;
    }
}

