/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker.strategy;

import brooklyn.entity.Entity;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.strategy.AbstractDockerPlacementStrategy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreadthFirstPlacementStrategy
extends AbstractDockerPlacementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BreadthFirstPlacementStrategy.class);
    private final AtomicInteger counter = new AtomicInteger(0);

    @Override
    public List<DockerHostLocation> filterLocations(List<DockerHostLocation> locations, Entity context) {
        if (locations == null || locations.isEmpty()) {
            return ImmutableList.of();
        }
        int size = Iterables.size(locations);
        int next = this.counter.incrementAndGet() % size;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Breadth first strategy using {} of {}", (Object)next, (Object)size);
        }
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.skip(locations, (int)next), (Iterable)Iterables.limit(locations, (int)next)));
    }
}

