/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.container.DockerCallbacks;
import brooklyn.entity.container.DockerUtils;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.location.Location;
import brooklyn.location.PortRange;
import brooklyn.location.access.PortForwardManager;
import brooklyn.location.basic.HasSubnetHostname;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.basic.SupportsPortForwarding;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.dynamic.DynamicLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsSshMachineLocation;
import brooklyn.location.jclouds.JcloudsUtil;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.net.Cidr;
import brooklyn.util.net.Protocol;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.ssh.IptablesCommands;
import brooklyn.util.time.Duration;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerLocation
extends SshMachineLocation
implements SupportsPortForwarding,
HasSubnetHostname,
DynamicLocation<DockerContainer, DockerContainerLocation> {
    private static final long serialVersionUID = 610389734596906782L;
    private static final Logger LOG = LoggerFactory.getLogger(DockerContainerLocation.class);
    @SetFromFlag(value="entity")
    private Entity entity;
    @SetFromFlag(value="machine")
    private JcloudsSshMachineLocation machine;
    @SetFromFlag(value="owner")
    private DockerContainer dockerContainer;

    public void init() {
        super.init();
    }

    public DockerContainer getOwner() {
        return this.dockerContainer;
    }

    public JcloudsSshMachineLocation getMachine() {
        return this.machine;
    }

    private void addIptablesRule(Integer port) {
        if (((Boolean)this.getOwner().config().get(DockerHost.OPEN_IPTABLES)).booleanValue()) {
            SshMachineLocation host = ((DockerHostLocation)this.getOwner().getDockerHost().getDynamicLocation()).getMachine();
            LOG.debug("Using iptables to add access for TCP/{} to {}", (Object)port, (Object)host);
            ImmutableList commands = ImmutableList.of((Object)BashCommands.sudo((String)("iptables -L INPUT -nv | grep -q 'tcp dpt:" + port + "'")), (Object)String.format("if [ $? -eq 0 ]; then ( %s ); else ( %s ); fi", BashCommands.sudo((String)("iptables -C INPUT -s 0/0 -p tcp --dport " + port + " -j ACCEPT")), IptablesCommands.insertIptablesRule((IptablesCommands.Chain)IptablesCommands.Chain.INPUT, (Protocol)Protocol.TCP, (int)port, (IptablesCommands.Policy)IptablesCommands.Policy.ACCEPT)));
            int result = host.execCommands(String.format("Open iptables TCP/%d", port), (List)commands);
            if (result != 0) {
                String msg = String.format("Error running iptables update for TCP/%d on %s", port, host);
                LOG.error(msg);
                throw new RuntimeException(msg);
            }
        }
    }

    public int getMappedPort(int portNumber) {
        String containerId = this.getOwner().getContainerId();
        Map mapping = JcloudsUtil.dockerPortMappingsFor((JcloudsLocation)this.getOwner().getDockerHost().getJcloudsLocation(), (String)containerId);
        Integer publicPort = (Integer)mapping.get(portNumber);
        if (publicPort == null) {
            LOG.warn("Unable to map port {} for Container {}. Mappings: {}", new Object[]{portNumber, containerId, Joiner.on((String)", ").withKeyValueSeparator("=").join(mapping)});
            publicPort = -1;
        } else {
            LOG.debug("Docker mapped port {} to {} for Container {}", new Object[]{portNumber, publicPort, containerId});
        }
        return publicPort;
    }

    public boolean obtainSpecificPort(int portNumber) {
        boolean result = this.machine.obtainSpecificPort(portNumber);
        if (result) {
            int targetPort = this.getMappedPort(portNumber);
            this.mapPort(targetPort, portNumber);
            this.addIptablesRule(targetPort);
        }
        return result;
    }

    public int obtainPort(PortRange range) {
        int portNumber = this.machine.obtainPort(range);
        int targetPort = this.getMappedPort(portNumber);
        this.mapPort(targetPort, portNumber);
        this.addIptablesRule(targetPort);
        return portNumber;
    }

    private void mapPort(int hostPort, int containerPort) {
        String dockerHost = this.getAddress().getHostAddress();
        PortForwardManager portForwardManager = this.getOwner().getDockerHost().getSubnetTier().getPortForwardManager();
        portForwardManager.recordPublicIpHostname(dockerHost, dockerHost);
        portForwardManager.acquirePublicPortExplicit(dockerHost, hostPort);
        portForwardManager.associate(dockerHost, hostPort, (Location)this, containerPort);
    }

    public HostAndPort getSocketEndpointFor(Cidr accessor, int privatePort) {
        String dockerHost = this.getAddress().getHostAddress();
        int hostPort = this.getMappedPort(privatePort);
        return HostAndPort.fromParts((String)dockerHost, (int)hostPort);
    }

    public int execScript(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        Iterable filtered = Iterables.filter(commands, DockerCallbacks.FILTER);
        for (String commandString : filtered) {
            this.parseDockerCallback(commandString);
        }
        return super.execScript(props, summaryForLogging, commands, env);
    }

    public int execCommands(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        Iterable filtered = Iterables.filter(commands, DockerCallbacks.FILTER);
        for (String commandString : filtered) {
            this.parseDockerCallback(commandString);
        }
        return super.execCommands(props, summaryForLogging, commands, env);
    }

    private void parseDockerCallback(String commandString) {
        List tokens = DockerCallbacks.PARSER.splitToList((CharSequence)commandString);
        int callback = Iterables.indexOf((Iterable)tokens, (Predicate)Predicates.equalTo((Object)"docker-host-callback"));
        if (callback == -1) {
            LOG.warn("Could not find callback token: {}", (Object)commandString);
            throw new IllegalStateException("Cannot find callback token in command line");
        }
        String command = (String)tokens.get(callback + 1);
        LOG.info("Executing callback for {}: {}", (Object)this.getOwner(), (Object)command);
        if ("commit".equalsIgnoreCase(command)) {
            String containerId = this.getOwner().getContainerId();
            String imageName = (String)this.getOwner().getAttribute(DockerContainer.IMAGE_NAME);
            String output = this.getOwner().getDockerHost().runDockerCommandTimeout(String.format("commit %s %s", containerId, imageName), Duration.minutes((Number)20));
            String imageId = DockerUtils.checkId(output);
            ((EntityLocal)this.getOwner().getRunningEntity()).setAttribute(DockerContainer.IMAGE_ID, (Object)imageId);
            ((EntityLocal)this.getOwner()).setAttribute(DockerContainer.IMAGE_ID, (Object)imageId);
            ((DockerHostLocation)this.getOwner().getDockerHost().getDynamicLocation()).markImage(imageName);
        } else if ("push".equalsIgnoreCase(command)) {
            String imageName = (String)this.getOwner().getAttribute(DockerContainer.IMAGE_NAME);
            this.getOwner().getDockerHost().runDockerCommand(String.format("push %s", imageName));
        } else if ("subnet-address".equalsIgnoreCase(command)) {
            String address = (String)this.getOwner().getAttribute(Attributes.SUBNET_ADDRESS);
            ((EntityLocal)this.getOwner().getRunningEntity()).setAttribute(Attributes.SUBNET_ADDRESS, (Object)address);
            ((EntityLocal)this.getOwner().getRunningEntity()).setAttribute(Attributes.SUBNET_HOSTNAME, (Object)address);
        } else {
            LOG.warn("Unknown Docker host command: {}", (Object)command);
        }
    }

    public void releasePort(int portNumber) {
        this.machine.releasePort(portNumber);
    }

    public InetAddress getAddress() {
        return ((DockerHostLocation)this.getOwner().getDockerHost().getDynamicLocation()).getMachine().getAddress();
    }

    public void close() throws IOException {
        LOG.debug("Close called on Docker container {}: {}", (Object)this.machine, (Object)this);
        try {
            this.machine.close();
            if (((Boolean)this.dockerContainer.getAttribute(DockerContainer.SERVICE_UP)).booleanValue()) {
                LOG.info("Stopping Docker container entity for {}: {}", (Object)this, (Object)this.dockerContainer);
                this.dockerContainer.stop();
            }
            LOG.info("Docker container closed: {}", (Object)this);
        }
        catch (Exception e) {
            LOG.warn("Error closing Docker container {}: {}", (Object)this, (Object)e.getMessage());
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Objects.ToStringHelper string() {
        return super.string().add("entity", (Object)this.entity).add("machine", (Object)this.machine).add("owner", (Object)this.dockerContainer);
    }

    public String getSubnetHostname() {
        return this.getSubnetIp();
    }

    public String getSubnetIp() {
        String containerId = (String)Preconditions.checkNotNull((Object)this.getOwner().getContainerId(), (Object)"containerId");
        String containerAddress = this.getOwner().getDockerHost().runDockerCommand("inspect --format={{.NetworkSettings.IPAddress}} " + containerId);
        return containerAddress.trim();
    }
}

