/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.etcd;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.nosql.etcd.EtcdNodeImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;

@Catalog(name="Etcd Node")
@ImplementedBy(value=EtcdNodeImpl.class)
public interface EtcdNode
extends SoftwareProcess {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"2.0.11");
    @SetFromFlag(value="downloadUrl")
    public static final ConfigKey<String> DOWNLOAD_URL = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.DOWNLOAD_URL.getConfigKey(), (Object)"https://github.com/coreos/etcd/releases/download/v${version}/etcd-v${version}-linux-amd64.tar.gz");
    @SetFromFlag(value="etcdClientPort")
    public static final PortAttributeSensorAndConfigKey ETCD_CLIENT_PORT = new PortAttributeSensorAndConfigKey("etcd.port.client", "Etcd client port", (Object)"2379");
    @SetFromFlag(value="etcdPeerPort")
    public static final PortAttributeSensorAndConfigKey ETCD_PEER_PORT = new PortAttributeSensorAndConfigKey("etcd.port.peer", "Etcd peer port", (Object)"2380");
    @SetFromFlag(value="nodeName")
    public static final AttributeSensorAndConfigKey<String, String> ETCD_NODE_NAME = ConfigKeys.newStringSensorAndConfigKey((String)"etcd.node.name", (String)"Returns the Etcd node name");
    public static final AttributeSensor<Boolean> ETCD_NODE_INSTALLED = Sensors.newBooleanSensor((String)"etcd.node.installed", (String)"Set when the etcd software has been installed");
    public static final AttributeSensor<Entity> ETCD_CLUSTER = Sensors.newSensor(Entity.class, (String)"etcd.cluster", (String)"Returns the Etcd cluster entity");
    public static final AttributeSensor<Boolean> ETCD_NODE_HAS_JOINED_CLUSTER = Sensors.newBooleanSensor((String)"etcd.node.nodeHasJoinedCluster", (String)"Flag to indicate whether the etcd node has joined a cluster member");
    public static final MethodEffector<Void> JOIN_ETCD_CLUSTER = new MethodEffector(EtcdNode.class, "joinCluster");
    public static final MethodEffector<Void> LEAVE_ETCD_CLUSTER = new MethodEffector(EtcdNode.class, "leaveCluster");

    @Effector(description="Add this etcd node to the etcd cluster")
    public void joinCluster(@EffectorParam(name="nodeName") String var1, @EffectorParam(name="nodeAddress") String var2);

    @Effector(description="Remove this etcd node from the cluster")
    public void leaveCluster(@EffectorParam(name="nodeName") String var1);

    public boolean hasJoinedCluster();
}

