/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.enricher.Enrichers;
import brooklyn.entity.Application;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BasicGroup;
import brooklyn.entity.basic.BasicStartableImpl;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.DynamicGroup;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.DockerAttributes;
import brooklyn.entity.container.DockerUtils;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.container.policy.ContainerHeadroomEnricher;
import brooklyn.entity.group.Cluster;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.group.DynamicMultiGroup;
import brooklyn.entity.machine.MachineAttributes;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationResolver;
import brooklyn.location.basic.BasicLocationDefinition;
import brooklyn.location.basic.BasicLocationRegistry;
import brooklyn.location.docker.DockerLocation;
import brooklyn.location.docker.DockerResolver;
import brooklyn.management.LocationManager;
import brooklyn.management.ManagementContext;
import brooklyn.networking.sdn.SdnAttributes;
import brooklyn.policy.EnricherSpec;
import brooklyn.policy.PolicySpec;
import brooklyn.policy.autoscaling.AutoScalerPolicy;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.QuorumCheck;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerInfrastructureImpl
extends BasicStartableImpl
implements DockerInfrastructure {
    private static final Logger LOG = LoggerFactory.getLogger(DockerInfrastructure.class);

    public void init() {
        LOG.info("Starting Docker infrastructure id {}", (Object)this.getId());
        this.registerLocationResolver();
        super.init();
        this.setAttribute(DOCKER_HOST_COUNTER, new AtomicInteger(0));
        this.setAttribute(DOCKER_CONTAINER_COUNTER, new AtomicInteger(0));
        int initialSize = (Integer)this.config().get(DOCKER_HOST_CLUSTER_MIN_SIZE);
        EntitySpec dockerHostSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.config().get((ConfigKey.HasConfigKey)DOCKER_HOST_SPEC))).configure(DockerHost.DOCKER_INFRASTRUCTURE, (Object)this).configure(DockerHost.RUNTIME_FILES, (Object)ImmutableMap.of((Object)this.config().get(DOCKER_CERTIFICATE_PATH), (Object)"cert.pem", (Object)this.config().get(DOCKER_KEY_PATH), (Object)"key.pem")).configure(SoftwareProcess.CHILDREN_STARTABLE_MODE, (Object)SoftwareProcess.ChildStartableMode.BACKGROUND_LATE);
        String dockerVersion = (String)this.config().get(DOCKER_VERSION);
        if (Strings.isNonBlank((CharSequence)dockerVersion)) {
            dockerHostSpec.configure(SoftwareProcess.SUGGESTED_VERSION, (Object)dockerVersion);
        }
        if (Boolean.TRUE.equals(this.config().get(SdnAttributes.SDN_DEBUG))) {
            dockerHostSpec.configure(DockerAttributes.DOCKERFILE_URL, (Object)"classpath://brooklyn/entity/container/docker/ubuntu/NetworkingDockerfile");
        }
        DynamicCluster hosts = (DynamicCluster)this.addChild((EntitySpec)EntitySpec.create(DynamicCluster.class).configure((ConfigKey)Cluster.INITIAL_SIZE, (Object)initialSize).configure(DynamicCluster.QUARANTINE_FAILED_ENTITIES, (Object)true).configure(DynamicCluster.MEMBER_SPEC, (Object)dockerHostSpec).configure(DynamicCluster.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).configure(DynamicCluster.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).displayName("Docker Hosts"));
        DynamicGroup fabric = (DynamicGroup)this.addChild((EntitySpec)EntitySpec.create(DynamicGroup.class).configure(DynamicGroup.ENTITY_FILTER, (Object)Predicates.and((Predicate)Predicates.instanceOf(DockerContainer.class), (Predicate)EntityPredicates.attributeEqualTo(DockerContainer.DOCKER_INFRASTRUCTURE, (Object)this))).configure(DynamicGroup.MEMBER_DELEGATE_CHILDREN, (Object)true).displayName("All Docker Containers"));
        DynamicMultiGroup buckets = (DynamicMultiGroup)this.addChild((EntitySpec)EntitySpec.create(DynamicMultiGroup.class).configure(DynamicMultiGroup.ENTITY_FILTER, DockerUtils.sameInfrastructure((Entity)this)).configure(DynamicMultiGroup.RESCAN_INTERVAL, (Object)15L).configure(DynamicMultiGroup.BUCKET_FUNCTION, (Object)new Function<Entity, String>(){

            public String apply(@Nullable Entity input) {
                return input.getApplication().getDisplayName() + ":" + input.getApplicationId();
            }
        }).configure(DynamicMultiGroup.BUCKET_SPEC, (Object)EntitySpec.create(BasicGroup.class).configure(BasicGroup.MEMBER_DELEGATE_CHILDREN, (Object)true)).displayName("Docker Applications"));
        if (((Boolean)this.config().get(SDN_ENABLE)).booleanValue() && this.config().get(SDN_PROVIDER_SPEC) != null) {
            Entity sdn = this.addChild(EntitySpec.create((EntitySpec)((EntitySpec)this.config().get(SDN_PROVIDER_SPEC))).configure(DockerAttributes.DOCKER_INFRASTRUCTURE, (Object)this));
            this.setAttribute(SDN_PROVIDER, sdn);
            if (Entities.isManaged((Entity)this)) {
                Entities.manage((Entity)sdn);
            }
        }
        if (Entities.isManaged((Entity)this)) {
            Entities.manage((Entity)hosts);
            Entities.manage((Entity)fabric);
            Entities.manage((Entity)buckets);
        }
        this.setAttribute(DOCKER_HOST_CLUSTER, hosts);
        this.setAttribute(DOCKER_CONTAINER_FABRIC, fabric);
        this.setAttribute(DOCKER_APPLICATIONS, buckets);
        hosts.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(DockerHost.CPU_USAGE).computingAverage()).fromMembers()).publishing(MachineAttributes.AVERAGE_CPU_USAGE).valueToReportIfNoSensors((Object)0.0)).build());
        hosts.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(DOCKER_CONTAINER_COUNT).computingSum()).fromMembers()).publishing(DOCKER_CONTAINER_COUNT).build());
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{DOCKER_CONTAINER_COUNT, MachineAttributes.AVERAGE_CPU_USAGE}).from((Entity)hosts)).build());
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating((Map)ImmutableMap.of((Object)DynamicCluster.GROUP_SIZE, (Object)DOCKER_HOST_COUNT)).from((Entity)hosts)).build());
        Integer headroom = (Integer)this.config().get(ContainerHeadroomEnricher.CONTAINER_HEADROOM);
        Double headroomPercent = (Double)this.config().get(ContainerHeadroomEnricher.CONTAINER_HEADROOM_PERCENTAGE);
        if (headroom != null && headroom > 0 || headroomPercent != null && headroomPercent > 0.0) {
            this.addEnricher(EnricherSpec.create(ContainerHeadroomEnricher.class).configure(ContainerHeadroomEnricher.CONTAINER_HEADROOM, (Object)headroom).configure(ContainerHeadroomEnricher.CONTAINER_HEADROOM_PERCENTAGE, (Object)headroomPercent));
            hosts.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_COLD, ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_HOT, ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_OK}).from((Entity)this)).build());
            hosts.addPolicy(PolicySpec.create(AutoScalerPolicy.class).configure(AutoScalerPolicy.POOL_COLD_SENSOR, ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_COLD).configure(AutoScalerPolicy.POOL_HOT_SENSOR, ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_HOT).configure(AutoScalerPolicy.POOL_OK_SENSOR, ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_OK).configure(AutoScalerPolicy.MIN_POOL_SIZE, (Object)initialSize).configure(AutoScalerPolicy.RESIZE_UP_STABILIZATION_DELAY, (Object)Duration.THIRTY_SECONDS).configure(AutoScalerPolicy.RESIZE_DOWN_STABILIZATION_DELAY, (Object)Duration.FIVE_MINUTES));
        }
        this.setAttribute(Attributes.MAIN_URI, URI.create("/clocker"));
    }

    private void registerLocationResolver() {
        LocationRegistry registry = this.getManagementContext().getLocationRegistry();
        DockerResolver dockerResolver = new DockerResolver();
        ((BasicLocationRegistry)registry).registerResolver((LocationResolver)dockerResolver);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Explicitly registered docker resolver: " + dockerResolver);
        }
    }

    @Override
    public List<Entity> getDockerHostList() {
        if (this.getDockerHostCluster() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.getDockerHostCluster().getMembers());
    }

    @Override
    public DynamicCluster getDockerHostCluster() {
        return (DynamicCluster)this.getAttribute(DOCKER_HOST_CLUSTER);
    }

    @Override
    public List<Entity> getDockerContainerList() {
        if (this.getContainerFabric() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.getContainerFabric().getMembers());
    }

    @Override
    public DynamicGroup getContainerFabric() {
        return (DynamicGroup)this.getAttribute(DOCKER_CONTAINER_FABRIC);
    }

    public Integer resize(Integer desiredSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resize Docker infrastructure to {} at {}", new Object[]{desiredSize, this.getLocations()});
        }
        return this.getDockerHostCluster().resize(desiredSize);
    }

    public Integer getCurrentSize() {
        return this.getDockerHostCluster().getCurrentSize();
    }

    public DockerLocation getDynamicLocation() {
        return (DockerLocation)this.getAttribute(DYNAMIC_LOCATION);
    }

    public boolean isLocationAvailable() {
        return this.getDynamicLocation() != null;
    }

    public DockerLocation createLocation(Map<String, ?> flags) {
        LocationDefinition check;
        String locationName = (String)this.config().get((ConfigKey.HasConfigKey)LOCATION_NAME);
        if (Strings.isBlank((CharSequence)locationName)) {
            String prefix = (String)this.config().get(LOCATION_NAME_PREFIX);
            String suffix = (String)this.config().get(LOCATION_NAME_SUFFIX);
            locationName = Joiner.on((String)"-").skipNulls().join((Object)prefix, (Object)this.getId(), new Object[]{suffix});
        }
        if ((check = this.getManagementContext().getLocationRegistry().getDefinedLocationByName(locationName)) != null) {
            throw new IllegalStateException("Location " + locationName + " is already defined: " + check);
        }
        String locationSpec = String.format("docker:%s", this.getId()) + String.format(":(name=\"%s\")", locationName);
        this.setAttribute(LOCATION_SPEC, locationSpec);
        BasicLocationDefinition definition = new BasicLocationDefinition(locationName, locationSpec, flags);
        Location location = this.getManagementContext().getLocationRegistry().resolve((LocationDefinition)definition);
        this.getManagementContext().getLocationRegistry().updateDefinedLocation((LocationDefinition)definition);
        this.getManagementContext().getLocationManager().manage(location);
        ManagementContext.PropertiesReloadListener listener = DockerUtils.reloadLocationListener(this.getManagementContext(), (LocationDefinition)definition);
        this.getManagementContext().addPropertiesReloadListener(listener);
        this.setAttribute(Attributes.PROPERTIES_RELOAD_LISTENER, listener);
        this.setAttribute(LOCATION_DEFINITION, definition);
        this.setAttribute(DYNAMIC_LOCATION, location);
        this.setAttribute((AttributeSensor)LOCATION_NAME, location.getId());
        LOG.info("New Docker location {} created", (Object)location);
        return (DockerLocation)location;
    }

    public void rebind() {
        super.rebind();
        ManagementContext.PropertiesReloadListener listener = (ManagementContext.PropertiesReloadListener)this.getAttribute(Attributes.PROPERTIES_RELOAD_LISTENER);
        if (listener != null) {
            listener.reloaded();
        }
    }

    public void deleteLocation() {
        ManagementContext.PropertiesReloadListener listener;
        DockerLocation location = this.getDynamicLocation();
        if (location != null) {
            LocationDefinition definition;
            LocationManager mgr = this.getManagementContext().getLocationManager();
            if (mgr.isManaged((Location)location)) {
                mgr.unmanage((Location)location);
            }
            if ((definition = (LocationDefinition)this.getAttribute(LOCATION_DEFINITION)) != null) {
                this.getManagementContext().getLocationRegistry().removeDefinedLocation(definition.getId());
            }
        }
        if ((listener = (ManagementContext.PropertiesReloadListener)this.getAttribute(Attributes.PROPERTIES_RELOAD_LISTENER)) != null) {
            this.getManagementContext().removePropertiesReloadListener(listener);
        }
        this.setAttribute(LOCATION_DEFINITION, null);
        this.setAttribute(DYNAMIC_LOCATION, null);
        this.setAttribute((AttributeSensor)LOCATION_NAME, null);
    }

    public void start(Collection<? extends Location> locations) {
        this.setAttribute(SERVICE_UP, Boolean.FALSE);
        Location provisioner = (Location)Iterables.getOnlyElement(locations);
        LOG.info("Creating new DockerLocation wrapping {}", (Object)provisioner);
        MutableMap flags = MutableMap.builder().putAll((Map)this.config().get(LOCATION_FLAGS)).put((Object)"provisioner", (Object)provisioner).putIfNotNull((Object)"strategies", this.config().get(PLACEMENT_STRATEGIES)).build();
        this.createLocation((Map)flags);
        super.start(locations);
        this.setAttribute(SERVICE_UP, Boolean.TRUE);
    }

    public void stop() {
        this.setAttribute(SERVICE_UP, Boolean.FALSE);
        Duration timeout = (Duration)this.config().get(SHUTDOWN_TIMEOUT);
        try {
            Iterable entities = Iterables.filter((Iterable)this.getManagementContext().getEntityManager().getEntities(), DockerUtils.sameInfrastructure((Entity)this));
            ImmutableSet applications = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)entities, (Function)new Function<Entity, Application>(){

                public Application apply(Entity input) {
                    return input.getApplication();
                }
            }));
            LOG.debug("Stopping applications: {}", (Object)Iterables.toString((Iterable)applications));
            Entities.invokeEffectorList((EntityLocal)this, (Iterable)applications, (Effector)Startable.STOP).get(timeout);
        }
        catch (Exception e) {
            LOG.warn("Error stopping applications", (Throwable)e);
        }
        if (((Boolean)this.config().get(SDN_ENABLE)).booleanValue()) {
            try {
                Entity sdn = (Entity)this.getAttribute(SDN_PROVIDER);
                LOG.debug("Stopping SDN: {}", (Object)sdn);
                Entities.invokeEffector((EntityLocal)this, (Entity)sdn, (Effector)Startable.STOP).get(timeout);
            }
            catch (Exception e) {
                LOG.warn("Error stopping SDN", (Throwable)e);
            }
        }
        try {
            DynamicCluster hosts = (DynamicCluster)this.getAttribute(DOCKER_HOST_CLUSTER);
            LOG.debug("Stopping hosts: {}", (Object)Iterables.toString((Iterable)hosts.getMembers()));
            Entities.invokeEffectorList((EntityLocal)this, (Iterable)hosts.getMembers(), (Effector)Startable.STOP).get(timeout);
        }
        catch (Exception e) {
            LOG.warn("Error stopping hosts", (Throwable)e);
        }
        super.stop();
        this.deleteLocation();
    }

    static {
        DockerAttributes.init();
        RendererHints.register((AttributeSensor)DOCKER_HOST_CLUSTER, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)DOCKER_CONTAINER_FABRIC, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)DOCKER_APPLICATIONS, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)SDN_PROVIDER, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
    }
}

