/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.BasicStartable;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.DynamicGroup;
import brooklyn.entity.container.DockerAttributes;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructureImpl;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.group.DynamicMultiGroup;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.Resizable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.docker.DockerLocation;
import brooklyn.location.docker.strategy.DepthFirstPlacementStrategy;
import brooklyn.location.docker.strategy.DockerAwarePlacementStrategy;
import brooklyn.location.docker.strategy.affinity.AffinityRules;
import brooklyn.location.dynamic.LocationOwner;
import brooklyn.networking.sdn.SdnAttributes;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@Catalog(name="Docker Infrastructure", description="Docker is an open-source engine to easily create lightweight, portable, self-sufficient containers from any application.", iconUrl="classpath:///docker-logo.png")
@ImplementedBy(value=DockerInfrastructureImpl.class)
public interface DockerInfrastructure
extends BasicStartable,
Resizable,
LocationOwner<DockerLocation, DockerInfrastructure> {
    @SetFromFlag(value="dockerVersion")
    public static final ConfigKey<String> DOCKER_VERSION = ConfigKeys.newStringConfigKey((String)"docker.version", (String)"The Docker Engine version number", (String)"1.6.2");
    @SetFromFlag(value="securityGroup")
    public static final ConfigKey<String> SECURITY_GROUP = ConfigKeys.newStringConfigKey((String)"docker.host.securityGroup", (String)"Set a network security group for cloud servers to use; (null to use default configuration)");
    @SetFromFlag(value="minHost")
    public static final ConfigKey<Integer> DOCKER_HOST_CLUSTER_MIN_SIZE = ConfigKeys.newConfigKeyWithPrefix((String)"docker.host.", (ConfigKey)DynamicCluster.INITIAL_SIZE);
    @SetFromFlag(value="strategies")
    public static final ConfigKey<List<DockerAwarePlacementStrategy>> PLACEMENT_STRATEGIES = ConfigKeys.newConfigKeyWithDefault(DockerAttributes.PLACEMENT_STRATEGIES, (Object)MutableList.of((Object)new DepthFirstPlacementStrategy()));
    @SetFromFlag(value="highAvailabilty")
    public static final ConfigKey<Boolean> HA_POLICY_ENABLE = ConfigKeys.newBooleanConfigKey((String)"docker.policy.ha.enable", (String)"Enable high-availability and resilience/restart policies", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="removeEmptyHosts")
    public static final ConfigKey<Boolean> REMOVE_EMPTY_DOCKER_HOSTS = ConfigKeys.newBooleanConfigKey((String)"docker.host.removeEmpty", (String)"Remove empty Docker Hosts with no containers", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="enableSdn")
    public static final ConfigKey<Boolean> SDN_ENABLE = SdnAttributes.SDN_ENABLE;
    @SetFromFlag(value="sdnProviderSpec")
    public static final ConfigKey<EntitySpec> SDN_PROVIDER_SPEC = ConfigKeys.newConfigKey(EntitySpec.class, (String)"sdn.provider.spec", (String)"SDN provider entity specification");
    @SetFromFlag(value="hostSpec")
    public static final AttributeSensorAndConfigKey<EntitySpec, EntitySpec> DOCKER_HOST_SPEC = ConfigKeys.newSensorAndConfigKey(EntitySpec.class, (String)"docker.host.spec", (String)"Specification to use when creating child Docker Hosts", (Object)EntitySpec.create(DockerHost.class));
    public static final ConfigKey<Boolean> DOCKER_GENERATE_TLS_CERTIFICATES = ConfigKeys.newBooleanConfigKey((String)"docker.tls.generate", (String)"Generate the TLS required TLS certificate and keys for each host", (Boolean)Boolean.FALSE);
    public static final ConfigKey<String> DOCKER_CERTIFICATE_AUTHORITY_PATH = ConfigKeys.newStringConfigKey((String)"docker.tls.ca", (String)"The Docker Engine TLS CA certificate PEM file path", (String)"conf/ca-cert.pem");
    public static final ConfigKey<String> DOCKER_CERTIFICATE_PATH = ConfigKeys.newStringConfigKey((String)"docker.tls.certificate", (String)"The Docker Engine TLS Server certificate PEM file path", (String)"conf/server-cert.pem");
    public static final ConfigKey<String> DOCKER_KEY_PATH = ConfigKeys.newStringConfigKey((String)"docker.tls.key", (String)"The Docker Engine TLS Server key PEM file path", (String)"conf/server-key.pem");
    @SetFromFlag(value="dockerfileUrl")
    public static final ConfigKey<String> DOCKERFILE_URL = ConfigKeys.newConfigKeyWithDefault(DockerAttributes.DOCKERFILE_URL, (Object)"classpath://brooklyn/entity/container/docker/ubuntu/Dockerfile");
    @SetFromFlag(value="dockerfileName")
    public static final ConfigKey<String> DOCKERFILE_NAME = ConfigKeys.newConfigKeyWithDefault(DockerAttributes.DOCKERFILE_NAME, (Object)"ubuntu");
    @SetFromFlag(value="imageId")
    public static final ConfigKey<String> DOCKER_IMAGE_ID = DockerAttributes.DOCKER_IMAGE_ID.getConfigKey();
    @SetFromFlag(value="hardwareId")
    public static final ConfigKey<String> DOCKER_HARDWARE_ID = DockerAttributes.DOCKER_HARDWARE_ID.getConfigKey();
    @SetFromFlag(value="affinityRules")
    public static final ConfigKey<List<String>> DOCKER_HOST_AFFINITY_RULES = AffinityRules.AFFINITY_RULES;
    @SetFromFlag(value="shutdownTimeout")
    public static final ConfigKey<Duration> SHUTDOWN_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"docker.timeout.shutdown", (String)"Timeout to wait for children when shutting down", (Duration)Duration.FIVE_MINUTES);
    @SetFromFlag(value="substitutions")
    public static final ConfigKey<Map<String, Object>> DOCKERFILE_SUBSTITUTIONS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, Object>>(){}, (String)"docker.dockerfile.substitutions", (String)"Dockerfile template substitutions", (Object)MutableMap.of());
    public static final AttributeSensor<DynamicCluster> DOCKER_HOST_CLUSTER = Sensors.newSensor(DynamicCluster.class, (String)"docker.hosts", (String)"Docker host cluster");
    public static final AttributeSensor<DynamicGroup> DOCKER_CONTAINER_FABRIC = Sensors.newSensor(DynamicGroup.class, (String)"docker.fabric", (String)"Docker container fabric");
    public static final AttributeSensor<DynamicMultiGroup> DOCKER_APPLICATIONS = Sensors.newSensor(DynamicMultiGroup.class, (String)"docker.buckets", (String)"Docker applications");
    public static final AttributeSensor<Entity> SDN_PROVIDER = Sensors.newSensor(Entity.class, (String)"sdn.provider.network", (String)"SDN provider network entity");
    public static final AttributeSensor<AtomicInteger> DOCKER_HOST_COUNTER = Sensors.newSensor(AtomicInteger.class, (String)"docker.hosts.counter", (String)"Docker host counter");
    public static final AttributeSensor<AtomicInteger> DOCKER_CONTAINER_COUNTER = Sensors.newSensor(AtomicInteger.class, (String)"docker.containers.counter", (String)"Docker container counter");
    public static final AttributeSensor<Integer> DOCKER_HOST_COUNT = DockerAttributes.DOCKER_HOST_COUNT;
    public static final AttributeSensor<Integer> DOCKER_CONTAINER_COUNT = DockerAttributes.DOCKER_CONTAINER_COUNT;

    public List<Entity> getDockerHostList();

    public DynamicCluster getDockerHostCluster();

    public List<Entity> getDockerContainerList();

    public DynamicGroup getContainerFabric();
}

