/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.enricher.Enrichers;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityFunctions;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.DockerAttributes;
import brooklyn.entity.container.DockerUtils;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerHostDriver;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.group.Cluster;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.machine.MachineEntityImpl;
import brooklyn.entity.nosql.etcd.EtcdNode;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.event.feed.function.FunctionFeed;
import brooklyn.event.feed.function.FunctionPollConfig;
import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.PortRange;
import brooklyn.location.basic.BasicLocationDefinition;
import brooklyn.location.basic.Machines;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.DockerLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsLocationConfig;
import brooklyn.location.jclouds.networking.JcloudsLocationSecurityGroupCustomizer;
import brooklyn.location.jclouds.templates.PortableTemplateBuilder;
import brooklyn.management.LocationManager;
import brooklyn.management.TaskAdaptable;
import brooklyn.networking.portforwarding.DockerPortForwarder;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.SdnAttributes;
import brooklyn.networking.sdn.calico.CalicoNode;
import brooklyn.networking.sdn.ibm.SdnVeNetwork;
import brooklyn.networking.sdn.weave.WeaveNetwork;
import brooklyn.networking.subnet.SubnetTier;
import brooklyn.networking.subnet.SubnetTierImpl;
import brooklyn.policy.PolicySpec;
import brooklyn.policy.ha.ServiceFailureDetector;
import brooklyn.policy.ha.ServiceReplacer;
import brooklyn.policy.ha.ServiceRestarter;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.QuorumCheck;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.net.Cidr;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.task.system.ProcessTaskStub;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.StringPredicates;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHostImpl
extends MachineEntityImpl
implements DockerHost {
    private static final Logger LOG = LoggerFactory.getLogger(DockerHost.class);
    private transient FunctionFeed scan;

    public void init() {
        LOG.info("Starting Docker host id {}", (Object)this.getId());
        super.init();
        AtomicInteger counter = (AtomicInteger)((Entity)this.config().get((ConfigKey.HasConfigKey)DOCKER_INFRASTRUCTURE)).getAttribute(DockerInfrastructure.DOCKER_HOST_COUNTER);
        String dockerHostName = String.format((String)this.config().get(DockerHost.DOCKER_HOST_NAME_FORMAT), this.getId(), counter.incrementAndGet());
        this.setDisplayName(dockerHostName);
        this.setAttribute(DOCKER_HOST_NAME, dockerHostName);
        String password = (String)this.config().get(DOCKER_PASSWORD);
        if (Strings.isBlank((CharSequence)password)) {
            password = Identifiers.makeRandomId((int)8);
            this.config().set(DOCKER_PASSWORD, (Object)password);
        }
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_INFRASTRUCTURE);
        EntitySpec dockerContainerSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.config().get((ConfigKey.HasConfigKey)DOCKER_CONTAINER_SPEC))).configure(DockerContainer.DOCKER_HOST, (Object)this).configure(DockerContainer.DOCKER_INFRASTRUCTURE, (Object)this.getInfrastructure());
        if (((Boolean)this.config().get(DockerInfrastructure.HA_POLICY_ENABLE)).booleanValue()) {
            dockerContainerSpec.policy(PolicySpec.create(ServiceRestarter.class).configure(ServiceRestarter.FAILURE_SENSOR_TO_MONITOR, (Object)ServiceFailureDetector.ENTITY_FAILED));
        }
        this.setAttribute((AttributeSensor)DOCKER_CONTAINER_SPEC, dockerContainerSpec);
        DynamicCluster containers = (DynamicCluster)this.addChild((EntitySpec)EntitySpec.create(DynamicCluster.class).configure((ConfigKey)Cluster.INITIAL_SIZE, (Object)0).configure(DynamicCluster.QUARANTINE_FAILED_ENTITIES, (Object)false).configure(DynamicCluster.MEMBER_SPEC, (Object)dockerContainerSpec).configure(DynamicCluster.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).configure(DynamicCluster.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).displayName("Docker Containers"));
        if (((Boolean)this.config().get(DockerInfrastructure.HA_POLICY_ENABLE)).booleanValue()) {
            containers.addPolicy(PolicySpec.create(ServiceReplacer.class).configure(ServiceReplacer.FAILURE_SENSOR_TO_MONITOR, (Object)ServiceRestarter.ENTITY_RESTART_FAILED));
        }
        this.setAttribute(DOCKER_CONTAINER_CLUSTER, containers);
        if (Entities.isManaged((Entity)this)) {
            Entities.manage((Entity)containers);
        }
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating((Map)ImmutableMap.of((Object)DynamicCluster.GROUP_SIZE, DockerAttributes.DOCKER_CONTAINER_COUNT)).from((Entity)containers)).build());
    }

    protected Collection<Integer> getRequiredOpenPorts() {
        Collection ports = super.getRequiredOpenPorts();
        if (((Boolean)this.config().get(DockerInfrastructure.SDN_ENABLE)).booleanValue()) {
            Integer weavePort;
            Entity sdn = (Entity)((Entity)this.getAttribute((AttributeSensor)DockerHost.DOCKER_INFRASTRUCTURE)).getAttribute(DockerInfrastructure.SDN_PROVIDER);
            if (DockerUtils.isSdnProvider((Entity)this, "WeaveNetwork") && (weavePort = (Integer)sdn.config().get(WeaveNetwork.WEAVE_PORT)) != null) {
                ports.add(weavePort);
            }
            if (DockerUtils.isSdnProvider((Entity)this, "CalicoNetwork")) {
                Integer powerstripPort;
                PortRange etcdPort = (PortRange)sdn.config().get((ConfigKey.HasConfigKey)EtcdNode.ETCD_CLIENT_PORT);
                if (etcdPort != null) {
                    ports.add(etcdPort.iterator().next());
                }
                if ((powerstripPort = (Integer)sdn.config().get(CalicoNode.POWERSTRIP_PORT)) != null) {
                    ports.add(powerstripPort);
                }
            }
        }
        return ports;
    }

    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation location) {
        MutableMap flags = MutableMap.copyOf((Map)super.obtainProvisioningFlags(location));
        flags.putAll((Map)this.config().get(PROVISIONING_FLAGS));
        if (location instanceof JcloudsLocation) {
            ImmutableSet imageChoiceToRespect = ImmutableSet.of((Object)JcloudsLocationConfig.TEMPLATE_BUILDER, (Object)JcloudsLocationConfig.IMAGE_CHOOSER, (Object)JcloudsLocationConfig.IMAGE_ID, (Object)JcloudsLocationConfig.IMAGE_NAME_REGEX, (Object)JcloudsLocationConfig.IMAGE_DESCRIPTION_REGEX, (Object)JcloudsLocationConfig.OS_FAMILY, (Object[])new ConfigKey[]{JcloudsLocationConfig.OS_VERSION_REGEX, JcloudsLocationConfig.OS_64_BIT});
            ImmutableSet hardwareChoiceToRespect = ImmutableSet.of((Object)JcloudsLocationConfig.HARDWARE_ID, (Object)JcloudsLocationConfig.MIN_RAM, (Object)JcloudsLocationConfig.MIN_CORES, (Object)JcloudsLocationConfig.MIN_DISK);
            Map existingConfigOptions = ((JcloudsLocation)location).config().getBag().getAllConfig();
            TemplateBuilder template = (TemplateBuilder)flags.get(JcloudsLocationConfig.TEMPLATE_BUILDER.getName());
            boolean overrideImageChoice = true;
            for (ConfigKey key : imageChoiceToRespect) {
                if (existingConfigOptions.get(key.getName()) == null && flags.get(key.getName()) == null) continue;
                overrideImageChoice = false;
                break;
            }
            boolean overrideHardwareChoice = true;
            for (ConfigKey key : hardwareChoiceToRespect) {
                if (existingConfigOptions.get(key.getName()) == null && flags.get(key.getName()) == null) continue;
                overrideHardwareChoice = false;
                break;
            }
            if (overrideImageChoice) {
                LOG.debug("Customising image choice for {}", (Object)this);
                template = new PortableTemplateBuilder();
                if (this.isJcloudsLocation(location, "google-compute-engine")) {
                    template.osFamily(OsFamily.CENTOS).osVersionMatches("6");
                } else {
                    template.osFamily(OsFamily.UBUNTU).osVersionMatches("14.04");
                }
                template.os64Bit(true);
                flags.put(JcloudsLocationConfig.TEMPLATE_BUILDER.getName(), template);
            } else {
                LOG.debug("Not modifying existing image configuration for {}", (Object)this);
            }
            if (overrideHardwareChoice) {
                LOG.debug("Customising hardware choice for {}", (Object)this);
                if (template != null) {
                    template.minRam(2048);
                } else {
                    flags.put(JcloudsLocationConfig.MIN_RAM.getName(), 2048);
                }
            } else {
                LOG.debug("Not modifying existing hardware configuration for {}", (Object)this);
            }
            String securityGroup = (String)this.config().get(DockerInfrastructure.SECURITY_GROUP);
            if (Strings.isNonBlank((CharSequence)securityGroup)) {
                if (this.isJcloudsLocation(location, "google-compute-engine")) {
                    flags.put("networkName", securityGroup);
                } else {
                    flags.put("securityGroups", securityGroup);
                }
            } else {
                flags.put(JcloudsLocationConfig.JCLOUDS_LOCATION_CUSTOMIZERS.getName(), ImmutableList.of((Object)JcloudsLocationSecurityGroupCustomizer.getInstance((String)this.getApplicationId())));
            }
            if (this.isJcloudsLocation(location, "softlayer") && DockerUtils.isSdnProvider((Entity)this, "SdnVeNetwork")) {
                if (template == null) {
                    template = new PortableTemplateBuilder();
                }
                template.osFamily(OsFamily.CENTOS).osVersionMatches("6").os64Bit(true);
                Integer vlanId = (Integer)((Entity)((Entity)this.getAttribute((AttributeSensor)DOCKER_INFRASTRUCTURE)).getAttribute(DockerInfrastructure.SDN_PROVIDER)).config().get(SdnVeNetwork.VLAN_ID);
                template.options((TemplateOptions)SoftLayerTemplateOptions.Builder.diskType((String)Volume.Type.LOCAL.name()).primaryBackendNetworkComponentNetworkVlanId(vlanId).portSpeed(Integer.valueOf(1000)));
                flags.put(JcloudsLocationConfig.TEMPLATE_BUILDER.getName(), template);
            }
        }
        return flags;
    }

    private boolean isJcloudsLocation(MachineProvisioningLocation location, String providerName) {
        return location instanceof JcloudsLocation && ((JcloudsLocation)location).getProvider().equals(providerName);
    }

    public Integer resize(Integer desiredSize) {
        return this.getDockerContainerCluster().resize(desiredSize);
    }

    public String getShortName() {
        return "Docker Host";
    }

    public Integer getCurrentSize() {
        return this.getDockerContainerCluster().getCurrentSize();
    }

    public Class<?> getDriverInterface() {
        return DockerHostDriver.class;
    }

    public DockerHostDriver getDriver() {
        return (DockerHostDriver)super.getDriver();
    }

    @Override
    public Integer getDockerPort() {
        return (Integer)this.getAttribute((AttributeSensor)DOCKER_SSL_PORT);
    }

    @Override
    public String getDockerHostName() {
        return (String)this.getAttribute(DOCKER_HOST_NAME);
    }

    @Override
    public List<Entity> getDockerContainerList() {
        return ImmutableList.copyOf((Collection)this.getDockerContainerCluster().getMembers());
    }

    @Override
    public DockerInfrastructure getInfrastructure() {
        return (DockerInfrastructure)this.config().get((ConfigKey.HasConfigKey)DOCKER_INFRASTRUCTURE);
    }

    @Override
    public String getPassword() {
        return (String)this.config().get(DOCKER_PASSWORD);
    }

    @Override
    public String createSshableImage(String dockerFile, String name) {
        String imageId = this.getDriver().buildImage(dockerFile, name);
        LOG.debug("Successfully created image {} ({})", new Object[]{imageId, name});
        return imageId;
    }

    @Override
    public String layerSshableImageOn(String baseImage, String tag) {
        String imageId = this.getDriver().layerSshableImageOn(baseImage, tag);
        LOG.debug("Successfully created SSHable image {} from {}", (Object)imageId, (Object)baseImage);
        return imageId;
    }

    @Override
    public String runDockerCommand(String command) {
        return this.runDockerCommandTimeout(command, Duration.FIVE_MINUTES);
    }

    @Override
    public String runDockerCommandTimeout(String command, Duration timeout) {
        String stdout = this.execCommandTimeout(BashCommands.sudo((String)String.format("docker %s", command)), timeout);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully executed Docker {}: {}", (Object)Strings.getFirstWord((String)command), (Object)Strings.getFirstLine((String)stdout));
        }
        return stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deployArchive(String url) {
        Tasks.setBlockingDetails((String)("Deploy " + url));
        try {
            String string = this.getDriver().deployArchive(url);
            return string;
        }
        finally {
            Tasks.resetBlockingDetails();
        }
    }

    public DockerHostLocation getDynamicLocation() {
        return (DockerHostLocation)this.getAttribute(DYNAMIC_LOCATION);
    }

    public boolean isLocationAvailable() {
        return this.getDynamicLocation() != null;
    }

    @Override
    public DynamicCluster getDockerContainerCluster() {
        return (DynamicCluster)this.getAttribute(DOCKER_CONTAINER_CLUSTER);
    }

    @Override
    public JcloudsLocation getJcloudsLocation() {
        return (JcloudsLocation)this.getAttribute(JCLOUDS_DOCKER_LOCATION);
    }

    @Override
    public SubnetTier getSubnetTier() {
        return (SubnetTier)this.getAttribute(DOCKER_HOST_SUBNET_TIER);
    }

    @Override
    public int execCommandStatus(String command) {
        return this.execCommandStatusTimeout(command, Duration.seconds((Number)15));
    }

    @Override
    public int execCommandStatusTimeout(String command, Duration timeout) {
        ProcessTaskWrapper task = ((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{command}).environmentVariables(((AbstractSoftwareProcessSshDriver)this.getDriver()).getShellEnvironment())).returning(ProcessTaskStub.ScriptReturnType.EXIT_CODE).allowingNonZeroExitCode()).machine(this.getMachine())).summary(command)).newTask();
        try {
            Object result = DynamicTasks.queueIfPossible((TaskAdaptable)task).executionContext((Entity)this).orSubmitAsync().asTask().get(timeout);
            return (Integer)result;
        }
        catch (TimeoutException te) {
            throw new IllegalStateException("Timed out running command: " + command);
        }
        catch (Exception e) {
            Integer exitCode = task.getExitCode();
            LOG.warn("Command failed, return code {}: {}", (Object)(exitCode == null ? -1 : exitCode), (Object)task.getStderr());
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public Optional<String> getImageNamed(String name) {
        return this.getImageNamed(name, "latest");
    }

    @Override
    public Optional<String> getImageNamed(String name, String tag) {
        String imageList = this.runDockerCommand("images --no-trunc " + name);
        return Optional.fromNullable((Object)Strings.getFirstWordAfter((String)imageList, (String)tag));
    }

    public DockerHostLocation createLocation(Map<String, ?> flags) {
        DockerInfrastructure infrastructure = this.getInfrastructure();
        DockerLocation docker = (DockerLocation)infrastructure.getDynamicLocation();
        String locationName = docker.getId() + "-" + this.getDockerHostName();
        String locationSpec = String.format("docker:%s:%s", infrastructure.getId(), this.getId()) + String.format(":(name=\"%s\")", locationName);
        this.setAttribute(LOCATION_SPEC, locationSpec);
        BasicLocationDefinition definition = new BasicLocationDefinition(locationName, locationSpec, flags);
        Location location = this.getManagementContext().getLocationRegistry().resolve((LocationDefinition)definition);
        this.setAttribute(DYNAMIC_LOCATION, location);
        this.setAttribute((AttributeSensor)LOCATION_NAME, location.getId());
        this.getManagementContext().getLocationManager().manage(location);
        LOG.info("New Docker host location {} created", (Object)location);
        return (DockerHostLocation)location;
    }

    public void deleteLocation() {
        LocationManager mgr;
        DockerHostLocation location = this.getDynamicLocation();
        if (location != null && (mgr = this.getManagementContext().getLocationManager()).isManaged((Location)location)) {
            mgr.unmanage((Location)location);
        }
        this.setAttribute(DYNAMIC_LOCATION, null);
        this.setAttribute((AttributeSensor)LOCATION_NAME, null);
    }

    protected void preStart() {
        this.getDriver().configureSecurityGroups();
        Integer dockerPort = this.getDockerPort();
        boolean tlsEnabled = true;
        if (DockerUtils.isSdnProvider((Entity)this, "CalicoNetwork")) {
            dockerPort = (Integer)((Entity)((Entity)this.getAttribute((AttributeSensor)DockerHost.DOCKER_INFRASTRUCTURE)).getAttribute(DockerInfrastructure.SDN_PROVIDER)).config().get(CalicoNode.POWERSTRIP_PORT);
            tlsEnabled = false;
        }
        Maybe found = Machines.findUniqueSshMachineLocation((Iterable)this.getLocations());
        String dockerLocationSpec = String.format("jclouds:docker:%s://%s:%s", tlsEnabled ? "https" : "http", ((SshMachineLocation)found.get()).getSshHostAndPort().getHostText(), dockerPort);
        String certificatePath = (String)this.config().get(DockerInfrastructure.DOCKER_CERTIFICATE_PATH);
        String keyPath = (String)this.config().get(DockerInfrastructure.DOCKER_KEY_PATH);
        JcloudsLocation jcloudsLocation = (JcloudsLocation)this.getManagementContext().getLocationRegistry().resolve(dockerLocationSpec, (Map)MutableMap.builder().put((Object)"identity", (Object)certificatePath).put((Object)"credential", (Object)keyPath).put((Object)"jclouds.image.login-user", (Object)("root:" + this.getPassword())).build());
        this.setAttribute(JCLOUDS_DOCKER_LOCATION, jcloudsLocation);
        DockerPortForwarder portForwarder = new DockerPortForwarder();
        portForwarder.injectManagementContext(this.getManagementContext());
        portForwarder.init(URI.create(jcloudsLocation.getEndpoint()));
        SubnetTier subnetTier = (SubnetTier)this.addChild(EntitySpec.create(SubnetTier.class, SubnetTierImpl.class).configure(SubnetTier.PORT_FORWARDER, (Object)portForwarder).configure(SubnetTier.SUBNET_CIDR, (Object)Cidr.UNIVERSAL));
        Entities.manage((Entity)subnetTier);
        subnetTier.start((Collection)ImmutableList.of((Object)found.get()));
        this.setAttribute(DOCKER_HOST_SUBNET_TIER, subnetTier);
        MutableMap flags = MutableMap.builder().putAll((Map)this.config().get(LOCATION_FLAGS)).put((Object)"machine", found.get()).put((Object)"jcloudsLocation", (Object)jcloudsLocation).put((Object)"portForwarder", (Object)portForwarder).build();
        this.createLocation((Map)flags);
    }

    public void postStart() {
        String imageId;
        ((EntityLocal)this.getAttribute(DOCKER_CONTAINER_CLUSTER)).setAttribute(SERVICE_UP, (Object)Boolean.TRUE);
        if (Boolean.TRUE.equals(((Entity)this.getAttribute((AttributeSensor)DOCKER_INFRASTRUCTURE)).config().get(SdnAttributes.SDN_ENABLE))) {
            LOG.info("Waiting on SDN agent");
            SdnAgent agent = (SdnAgent)Entities.attributeSupplierWhenReady((Entity)this, SdnAgent.SDN_AGENT).get();
            Entities.waitForServiceUp((Entity)agent);
            LOG.info("SDN agent running: " + agent.getAttribute(SERVICE_UP));
        }
        if (Strings.isBlank((CharSequence)(imageId = (String)this.config().get((ConfigKey.HasConfigKey)DOCKER_IMAGE_ID)))) {
            String dockerfileUrl = (String)this.config().get(DockerInfrastructure.DOCKERFILE_URL);
            String imageName = DockerUtils.imageName((Entity)this, dockerfileUrl);
            imageId = this.createSshableImage(dockerfileUrl, imageName);
            this.setAttribute(DOCKER_IMAGE_NAME, imageName);
        }
        this.setAttribute((AttributeSensor)DOCKER_IMAGE_ID, imageId);
        this.scan = this.scanner();
    }

    private FunctionFeed scanner() {
        Duration interval = (Duration)this.config().get(SCAN_INTERVAL);
        return FunctionFeed.builder().entity((EntityLocal)this).poll((FunctionPollConfig)((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(SCAN).period(interval)).description("Scan Containers")).callable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DockerHostImpl.this.scanContainers();
                return null;
            }
        }).onFailureOrException(Functions.constant(null))).build();
    }

    public void rebind() {
        super.rebind();
        if (this.scan == null) {
            this.scan = this.scanner();
        }
    }

    public void preStop() {
        boolean agentStopped;
        SdnAgent agent;
        if (this.scan != null && this.scan.isActivated()) {
            this.scan.stop();
        }
        if ((agent = (SdnAgent)this.getAttribute(SdnAgent.SDN_AGENT)) != null && !(agentStopped = Entities.invokeEffector((EntityLocal)this, (Entity)agent, (Effector)Startable.STOP).blockUntilEnded(Duration.TEN_SECONDS))) {
            LOG.debug("{} may not have stopped. Proceeding to stop {} anyway", (Object)agent, (Object)this);
        }
        super.preStop();
    }

    public void postStop() {
        super.postStop();
        this.deleteLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanContainers() {
        this.getDynamicLocation().getLock().lock();
        try {
            String output = this.runDockerCommand("ps");
            List ps = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n")).omitEmptyStrings().splitToList((CharSequence)output);
            if (ps.size() > 1) {
                for (int i = 1; i < ps.size(); ++i) {
                    String line = (String)ps.get(i);
                    String id = Strings.getFirstWord((String)line);
                    Optional container = Iterables.tryFind((Iterable)this.getDockerContainerCluster().getMembers(), (Predicate)Predicates.compose((Predicate)StringPredicates.startsWith((String)id), (Function)EntityFunctions.attribute(DockerContainer.CONTAINER_ID)));
                    if (container.isPresent()) continue;
                    String containerId = Strings.getFirstWord((String)this.runDockerCommand("inspect --format {{.Id}} " + id));
                    String imageId = Strings.getFirstWord((String)this.runDockerCommand("inspect --format {{.Image}} " + id));
                    String imageName = Strings.getFirstWord((String)this.runDockerCommand("inspect --format {{.Config.Image}} " + id));
                    EntitySpec containerSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.config().get((ConfigKey.HasConfigKey)DOCKER_CONTAINER_SPEC))).configure(SoftwareProcess.ENTITY_STARTED, (Object)Boolean.TRUE).configure(DockerContainer.DOCKER_HOST, (Object)this).configure(DockerContainer.DOCKER_INFRASTRUCTURE, (Object)this.getInfrastructure()).configure(DockerContainer.DOCKER_IMAGE_ID, (Object)imageId).configure(DockerAttributes.DOCKER_IMAGE_NAME, (Object)imageName).configure(DockerContainer.LOCATION_FLAGS, (Object)MutableMap.of((Object)"container", (Object)this.getMachine()));
                    DockerContainer added = (DockerContainer)this.getDockerContainerCluster().addChild(containerSpec);
                    Entities.manage((Entity)added);
                    this.getDockerContainerCluster().addMember((Entity)added);
                    ((EntityLocal)added).setAttribute(DockerContainer.CONTAINER_ID, (Object)containerId);
                    added.start((Collection)ImmutableList.of((Object)this.getDynamicLocation().getMachine()));
                }
            }
        }
        finally {
            this.getDynamicLocation().getLock().unlock();
        }
    }

    static {
        RendererHints.register((AttributeSensor)DOCKER_INFRASTRUCTURE, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)DOCKER_CONTAINER_CLUSTER, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
    }
}

