/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.database.DatastoreMixins;
import brooklyn.entity.messaging.MessageBroker;
import brooklyn.entity.nosql.couchbase.CouchbaseCluster;
import brooklyn.entity.nosql.couchbase.CouchbaseNode;
import brooklyn.entity.webapp.WebAppServiceConstants;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.docker.DockerContainerLocation;
import brooklyn.management.ManagementContext;
import brooklyn.networking.sdn.SdnAttributes;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;

public class DockerUtils {
    public static final String DOCKERFILE = "Dockerfile";
    public static final String MAPPED = "mapped";
    public static final String ENDPOINT = "endpoint";
    public static final String PORT = "port";
    public static final Set<String> URL_SENSOR_NAMES = ImmutableSet.of((Object)WebAppServiceConstants.ROOT_URL.getName(), (Object)DatastoreMixins.DATASTORE_URL.getName(), (Object)CouchbaseNode.COUCHBASE_WEB_ADMIN_URL.getName(), (Object)MessageBroker.BROKER_URL.getName());
    public static final Set<String> BLACKLIST_URL_SENSOR_NAMES = ImmutableSet.of((Object)SoftwareProcess.DOWNLOAD_URL.getName(), (Object)CouchbaseCluster.COUCHBASE_CLUSTER_CONNECTION_URL.getName());
    public static final String DEFAULT_DOCKER_CONTAINER_NAME_FORMAT = "docker-container-brooklyn-%1$s";
    public static final String DEFAULT_DOCKER_HOST_NAME_FORMAT = "docker-host-brooklyn-%1$s";
    public static final String UBUNTU_DOCKERFILE = "classpath://brooklyn/entity/container/docker/ubuntu/Dockerfile";
    public static final String UBUNTU_NETWORKING_DOCKERFILE = "classpath://brooklyn/entity/container/docker/ubuntu/NetworkingDockerfile";
    public static final String UBUNTU_USES_JAVA_DOCKERFILE = "classpath://brooklyn/entity/container/docker/ubuntu/UsesJavaDockerfile";
    public static final String CENTOS_DOCKERFILE = "classpath://brooklyn/entity/container/docker/centos/Dockerfile";
    public static final String COREOS_DOCKERFILE = "classpath://brooklyn/entity/container/docker/coreos/Dockerfile";
    public static final String SSHD_DOCKERFILE = "classpath://brooklyn/entity/container/docker/SshdDockerfile";
    public static final CharMatcher DOCKERFILE_CHARACTERS = CharMatcher.anyOf((CharSequence)"_").or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'0', (char)'9'));
    public static final CharMatcher DOCKERFILE_INVALID_CHARACTERS = DOCKERFILE_CHARACTERS.negate();
    public static final Function<String, String> ALLOWED = new Function<String, String>(){

        public String apply(@Nullable String input) {
            if (input == null) {
                return null;
            }
            return DOCKERFILE_INVALID_CHARACTERS.collapseFrom((CharSequence)input.toLowerCase(Locale.ENGLISH), '_');
        }
    };

    private DockerUtils() {
    }

    public static <T> AttributeSensor<T> mappedSensor(AttributeSensor<?> source) {
        return Sensors.newSensorWithPrefix((String)"mapped.", source);
    }

    public static AttributeSensor<String> mappedPortSensor(PortAttributeSensorAndConfigKey source) {
        return Sensors.newStringSensor((String)("mapped." + source.getName()), (String)(source.getDescription() + " (Docker mapping)"));
    }

    public static AttributeSensor<String> endpointSensor(PortAttributeSensorAndConfigKey source) {
        List name = Lists.transform((List)source.getNameParts(), (Function)new Function<String, String>(){

            public String apply(@Nullable String input) {
                String target = DockerUtils.PORT;
                if (input.equals(target)) {
                    return DockerUtils.ENDPOINT;
                }
                if (input.endsWith(target)) {
                    return input.replace(target, DockerUtils.ENDPOINT);
                }
                target = Strings.toInitialCapOnly((String)DockerUtils.PORT);
                if (input.endsWith(target)) {
                    return input.replace(target, Strings.toInitialCapOnly((String)DockerUtils.ENDPOINT));
                }
                return input;
            }
        });
        if (!name.contains(ENDPOINT)) {
            name.add(ENDPOINT);
        }
        return Sensors.newStringSensor((String)Joiner.on((String)".").join((Iterable)name), (String)(source.getDescription() + " (Docker mapping)"));
    }

    public static String allowed(String input) {
        return (String)ALLOWED.apply((Object)input);
    }

    public static String checkId(String input) {
        String imageId = Strings.trim((String)input).toLowerCase(Locale.ENGLISH);
        if (imageId.length() == 64 && DOCKERFILE_CHARACTERS.matchesAllOf((CharSequence)imageId)) {
            return imageId;
        }
        throw new IllegalStateException("Invalid image ID returned: " + imageId);
    }

    public static String imageName(Entity entity, String dockerfile) {
        String simpleName = entity.getEntityType().getSimpleName();
        String version = (String)entity.config().get(SoftwareProcess.SUGGESTED_VERSION);
        String label = Joiner.on((String)":").skipNulls().join((Object)simpleName, (Object)version, new Object[]{dockerfile});
        return Identifiers.makeIdFromHash((long)Hashing.md5().hashString((CharSequence)label, Charsets.UTF_8).asLong()).toLowerCase(Locale.ENGLISH);
    }

    public static boolean isSdnProvider(Entity dockerHost, String providerName) {
        if (((Boolean)dockerHost.config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
            Entity sdn = (Entity)((Entity)dockerHost.getAttribute(DockerHost.DOCKER_INFRASTRUCTURE)).getAttribute(DockerInfrastructure.SDN_PROVIDER);
            if (sdn == null) {
                return false;
            }
            return sdn.getEntityType().getSimpleName().equalsIgnoreCase(providerName);
        }
        return false;
    }

    public static final Predicate<Entity> sameInfrastructure(Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity");
        return new SameInfrastructurePredicate(entity.getId());
    }

    public static final ManagementContext.PropertiesReloadListener reloadLocationListener(ManagementContext context, LocationDefinition definition) {
        return new ReloadDockerLocation(context, definition);
    }

    public static class ReloadDockerLocation
    implements ManagementContext.PropertiesReloadListener {
        private final ManagementContext context;
        private final LocationDefinition definition;

        public ReloadDockerLocation(ManagementContext context, LocationDefinition definition) {
            this.context = (ManagementContext)Preconditions.checkNotNull((Object)context, (Object)"context");
            this.definition = (LocationDefinition)Preconditions.checkNotNull((Object)definition, (Object)"definition");
        }

        public void reloaded() {
            Location resolved = this.context.getLocationRegistry().resolve(this.definition);
            this.context.getLocationRegistry().updateDefinedLocation(this.definition);
            this.context.getLocationManager().manage(resolved);
        }
    }

    public static class SameInfrastructurePredicate
    implements Predicate<Entity> {
        private final String id;

        public SameInfrastructurePredicate(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        }

        public boolean apply(@Nullable Entity input) {
            Optional lookup = Iterables.tryFind((Iterable)input.getLocations(), (Predicate)Predicates.instanceOf(DockerContainerLocation.class));
            if (lookup.isPresent()) {
                DockerContainerLocation container = (DockerContainerLocation)((Object)lookup.get());
                return this.id.equals(container.getOwner().getDockerHost().getInfrastructure().getId());
            }
            return false;
        }
    }
}

