/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxy.haproxy;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ApplicationBuilder;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.DockerAttributes;
import brooklyn.entity.container.docker.AbstractClockerIntegrationTest;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.container.docker.DockerInfrastructureTests;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.proxy.haproxy.HAProxyController;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.webapp.JavaWebAppService;
import brooklyn.entity.webapp.WebAppService;
import brooklyn.entity.webapp.tomcat.TomcatServer;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.basic.Sensors;
import brooklyn.management.ManagementContext;
import brooklyn.test.EntityTestUtils;
import brooklyn.test.HttpTestUtils;
import brooklyn.test.TestResourceUnavailableException;
import brooklyn.test.entity.TestApplication;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.testng.annotations.Test;

public class HAProxyIntegrationTest
extends AbstractClockerIntegrationTest {
    private EntitySpec<HAProxyController> haProxySpec() {
        return EntitySpec.create(HAProxyController.class).configure((ConfigKey.HasConfigKey)DockerAttributes.DOCKER_IMAGE_NAME, (Object)"haproxy").configure((ConfigKey.HasConfigKey)DockerAttributes.DOCKER_IMAGE_TAG, (Object)"latest").configure((ConfigKey.HasConfigKey)SoftwareProcess.INSTALL_DIR, (Object)"/usr/local/sbin/").configure((ConfigKey.HasConfigKey)SoftwareProcess.RUN_DIR, (Object)"/usr/local/etc/haproxy/");
    }

    private EntitySpec<TomcatServer> tomcatSpec() {
        return EntitySpec.create(TomcatServer.class);
    }

    private String getTestWar() {
        TestResourceUnavailableException.throwIfResourceUnavailable(((Object)((Object)this)).getClass(), (String)"/hello-world.war");
        return "classpath://hello-world.war";
    }

    private AttributeSensor<String> mappedSensor(Sensor<String> sensor) {
        return Sensors.newStringSensor((String)("mapped." + sensor.getName()));
    }

    @Test(groups={"Integration"})
    public void testContainerFromImageName() {
        DockerInfrastructure infrastructure = DockerInfrastructureTests.deployAndWaitForDockerInfrastructure(this.app, this.testLocation);
        TestApplication testApp = (TestApplication)ApplicationBuilder.newManagedApp(TestApplication.class, (ManagementContext)this.app.getManagementContext());
        DynamicCluster serverPool = (DynamicCluster)testApp.createAndManageChild(EntitySpec.create(DynamicCluster.class).configure(DynamicCluster.MEMBER_SPEC, this.tomcatSpec()).configure((ConfigKey)DynamicCluster.INITIAL_SIZE, (Object)1).configure(JavaWebAppService.ROOT_WAR, (Object)this.getTestWar()));
        HAProxyController hap = (HAProxyController)testApp.createAndManageChild(this.haProxySpec().configure(HAProxyController.SERVER_POOL, (Object)serverPool).configure((ConfigKey.HasConfigKey)HAProxyController.HOSTNAME_SENSOR, (Object)Attributes.SUBNET_HOSTNAME));
        testApp.start((Collection)ImmutableList.of((Object)infrastructure.getDynamicLocation()));
        EntityTestUtils.assertAttributeEqualsEventually((Entity)hap, (AttributeSensor)Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.RUNNING);
        HttpTestUtils.assertHttpStatusCodeEventuallyEquals((String)((String)hap.getAttribute(this.mappedSensor((Sensor<String>)HAProxyController.ROOT_URL))), (int)200);
        for (Entity member : serverPool.getMembers()) {
            HttpTestUtils.assertHttpStatusCodeEventuallyEquals((String)((String)member.getAttribute(this.mappedSensor((Sensor<String>)WebAppService.ROOT_URL))), (int)200);
        }
        testApp.stop();
    }
}

