/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.Port;
import org.jclouds.docker.domain.State;
import org.jclouds.domain.Location;
import org.jclouds.providers.ProviderMetadata;

@Singleton
public class ContainerToNodeMetadata
implements Function<Container, NodeMetadata> {
    private final ProviderMetadata providerMetadata;
    private final Function<State, NodeMetadata.Status> toPortableStatus;
    private final GroupNamingConvention nodeNamingConvention;
    private final Supplier<Map<String, ? extends Image>> images;
    private final Supplier<Set<? extends Location>> locations;

    @Inject
    public ContainerToNodeMetadata(ProviderMetadata providerMetadata, Function<State, NodeMetadata.Status> toPortableStatus, GroupNamingConvention.Factory namingConvention, Supplier<Map<String, ? extends Image>> images, @Memoized Supplier<Set<? extends Location>> locations) {
        this.providerMetadata = (ProviderMetadata)Preconditions.checkNotNull((Object)providerMetadata, (Object)"providerMetadata");
        this.toPortableStatus = (Function)Preconditions.checkNotNull(toPortableStatus, (Object)"toPortableStatus cannot be null");
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images cannot be null");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
    }

    public NodeMetadata apply(Container container) {
        String name = this.cleanUpName(container.getName());
        String group = this.nodeNamingConvention.extractGroup(name);
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(container.getId()).name(name).group(group).hostname(container.getContainerConfig().getHostname()).hardware(new HardwareBuilder().id("").ram(container.getContainerConfig().getMemory()).processor(new Processor((double)container.getContainerConfig().getCpuShares(), (double)container.getContainerConfig().getCpuShares())).build());
        builder.status((NodeMetadata.Status)this.toPortableStatus.apply((Object)container.getState()));
        builder.imageId(container.getImage());
        builder.loginPort(ContainerToNodeMetadata.getLoginPort(container));
        builder.publicAddresses(this.getPublicIpAddresses());
        builder.privateAddresses(this.getPrivateIpAddresses(container));
        builder.location((Location)Iterables.getOnlyElement((Iterable)((Iterable)this.locations.get())));
        String imageId = container.getImage();
        builder.imageId(imageId);
        if (((Map)this.images.get()).containsKey(imageId)) {
            Image image = (Image)((Map)this.images.get()).get(imageId);
            builder.operatingSystem(image.getOperatingSystem());
        }
        return builder.build();
    }

    private String cleanUpName(String name) {
        return name.startsWith("/") ? name.substring(1) : name;
    }

    private Iterable<String> getPrivateIpAddresses(Container container) {
        if (container.getNetworkSettings() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)container.getNetworkSettings().getIpAddress());
    }

    private List<String> getPublicIpAddresses() {
        String dockerIpAddress = URI.create(this.providerMetadata.getEndpoint()).getHost();
        return ImmutableList.of((Object)dockerIpAddress);
    }

    protected static int getLoginPort(Container container) {
        if (container.getNetworkSettings() != null) {
            Map ports = container.getNetworkSettings().getPorts();
            if (ports != null) {
                return Integer.parseInt((String)((Map)Iterables.getOnlyElement((Iterable)((Iterable)ports.get("22/tcp")))).get("HostPort"));
            }
        } else if (container.getPorts() != null) {
            for (Port port : container.getPorts()) {
                if (port.getPrivatePort() != 22) continue;
                return port.getPublicPort();
            }
        }
        throw new IllegalStateException("Cannot determine the login port for " + container.getId());
    }
}

